/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.jdbc;

import jakarta.annotation.Nonnull;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.ConnectionWrapperFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class SpringDataSourceConnectionProvider
implements ConnectionProvider {
    private final DataSource dataSource;
    private final SpringConnectionCloseHandler closeHandler;

    public SpringDataSourceConnectionProvider(DataSource dataSource) {
        this.dataSource = dataSource;
        this.closeHandler = new SpringConnectionCloseHandler(dataSource);
    }

    @Nonnull
    public Connection getConnection() throws SQLException {
        Connection connection = DataSourceUtils.doGetConnection((DataSource)this.dataSource);
        return ConnectionWrapperFactory.wrap((Connection)connection, (ConnectionWrapperFactory.ConnectionCloseHandler)this.closeHandler);
    }

    private static class SpringConnectionCloseHandler
    implements ConnectionWrapperFactory.ConnectionCloseHandler {
        private final DataSource dataSource;

        public SpringConnectionCloseHandler(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void close(Connection delegate) {
            DataSourceUtils.releaseConnection((Connection)delegate, (DataSource)this.dataSource);
        }

        public void commit(Connection connection) throws SQLException {
            if (!DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)this.dataSource)) {
                connection.commit();
            }
        }
    }
}

