/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.StringUtils;
import org.axonframework.common.annotations.AnnotationUtils;
import org.axonframework.common.annotations.Internal;
import org.axonframework.spring.config.SpringEventSourcedEntityConfigurer;
import org.axonframework.spring.stereotype.EventSourced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

@Internal
public class SpringEventSourcedEntityLookup
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SpringEventSourcedEntityLookup.class);
    private static final String ID_TYPE_CLASS = "idType";

    static <E> Map<SpringEntity<? super E>, Map<Class<? extends E>, String>> buildEntityHierarchy(ListableBeanFactory beanFactory, String[] entityPrototypes) {
        HashMap<SpringEntity<E>, Map<Class<E>, String>> hierarchy = new HashMap<SpringEntity<E>, Map<Class<E>, String>>();
        for (String prototype : entityPrototypes) {
            Class entityType = beanFactory.getType(prototype);
            if (entityType == null) {
                logger.info("Cannot find Entity class for type [{}], hence ignoring.", (Object)prototype);
                break;
            }
            SpringEntity springEntity = new SpringEntity(prototype, entityType);
            Class<E> topType = SpringEventSourcedEntityLookup.topAnnotatedEntityType(entityType);
            SpringEntity<E> topSpringEntity = new SpringEntity<E>(SpringEventSourcedEntityLookup.beanName(beanFactory, topType), topType);
            hierarchy.compute(topSpringEntity, (type, subtypes) -> {
                if (subtypes == null) {
                    subtypes = new HashMap<Class, String>();
                }
                if (!type.equals(springEntity)) {
                    subtypes.put(entityType, prototype);
                }
                return subtypes;
            });
        }
        return hierarchy;
    }

    private static <A> String beanName(ListableBeanFactory beanFactory, Class<A> type) {
        String[] beanNamesForType = beanFactory.getBeanNamesForType(type);
        if (beanNamesForType.length == 0) {
            throw new AxonConfigurationException(String.format("There are no spring beans for '%s' defined.", type.getName()));
        }
        if (beanNamesForType.length != 1) {
            logger.debug("There are {} beans defined for type [{}], making this a polymorphic entities. There is a high likelihood the root is an abstract class, so no bean name is found. Hence we default to simple name of the root type.", (Object)beanNamesForType.length, (Object)type.getName());
            return StringUtils.lowerCaseFirstCharacterOf((String)type.getSimpleName());
        }
        return beanNamesForType[0];
    }

    private static <E> Class<? super E> topAnnotatedEntityType(Class<E> type) {
        Class<E> top;
        Class<E> topAnnotated = top = type;
        while (!Object.class.equals(top) && !Object.class.equals(top.getSuperclass())) {
            if (!(top = top.getSuperclass()).isAnnotationPresent(EventSourced.class)) continue;
            topAnnotated = top;
        }
        return topAnnotated;
    }

    public void postProcessBeanFactory(@Nonnull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof BeanDefinitionRegistry)) {
            logger.warn("Given bean factory is not a BeanDefinitionRegistry. Cannot auto-configure Entities");
            return;
        }
        BeanDefinitionRegistry bdRegistry = (BeanDefinitionRegistry)beanFactory;
        String[] entitiesBeans = beanFactory.getBeanNamesForAnnotation(EventSourced.class);
        Map hierarchy = SpringEventSourcedEntityLookup.buildEntityHierarchy((ListableBeanFactory)beanFactory, entitiesBeans);
        for (Map.Entry entity : hierarchy.entrySet()) {
            Class entityType = entity.getKey().getClassType();
            Map<Class<?>, String> entitySubtypes = entity.getValue();
            String entityPrototype = entity.getKey().getBeanName();
            String registrarBeanName = entityPrototype + "$$Registrar";
            if (beanFactory.containsBeanDefinition(registrarBeanName)) {
                logger.info("Registrar for {} already available. Skipping configuration", (Object)entityPrototype);
                break;
            }
            if (!SpringEventSourcedEntityLookup.hasSubtypesOrIsPrototype(entitySubtypes, beanFactory, entityPrototype) || entityType == null) continue;
            AnnotationUtils.findAnnotationAttributes(entityType, EventSourced.class).map(props -> this.buildEntityBeanDefinition(entityType, (Class)Objects.requireNonNull(props.get(ID_TYPE_CLASS), "Id type must be provided for " + entityPrototype))).ifPresent(registrarBeanDefinition -> bdRegistry.registerBeanDefinition(registrarBeanName, registrarBeanDefinition));
        }
    }

    private static boolean hasSubtypesOrIsPrototype(Map<Class<?>, String> entitySubtypes, ConfigurableListableBeanFactory beanFactory, String entityPrototype) {
        return !entitySubtypes.isEmpty() || beanFactory.getBeanDefinition(entityPrototype).isPrototype();
    }

    private BeanDefinition buildEntityBeanDefinition(Class<?> entityType, Class<?> idType) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpringEventSourcedEntityConfigurer.class).setRole(0).addConstructorArgValue(entityType).addConstructorArgValue(idType);
        return beanDefinitionBuilder.getBeanDefinition();
    }

    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry registry) throws BeansException {
    }

    static class SpringEntity<T> {
        private final String beanName;
        private final Class<T> classType;

        private SpringEntity(String beanName, Class<T> classType) {
            this.beanName = beanName;
            this.classType = classType;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public Class<T> getClassType() {
            return this.classType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpringEntity that = (SpringEntity)o;
            return Objects.equals(this.beanName, that.beanName) && Objects.equals(this.classType, that.classType);
        }

        public int hashCode() {
            return Objects.hash(this.beanName, this.classType);
        }
    }
}

