/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageHandler;
import org.axonframework.spring.config.MessageHandlerConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

public class MessageHandlerLookup
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MessageHandlerLookup.class);

    public static List<String> messageHandlerBeans(Class<? extends Message<?>> messageType, ConfigurableListableBeanFactory registry) {
        return MessageHandlerLookup.messageHandlerBeans(messageType, registry, false);
    }

    public static List<String> messageHandlerBeans(Class<? extends Message<?>> messageType, ConfigurableListableBeanFactory registry, boolean includePrototypeBeans) {
        ArrayList<String> found = new ArrayList<String>();
        for (String beanName : registry.getBeanDefinitionNames()) {
            Class beanType;
            BeanDefinition bd = registry.getBeanDefinition(beanName);
            if (!includePrototypeBeans && (!bd.isSingleton() || bd.isAbstract()) || (beanType = registry.getType(beanName)) == null || !MessageHandlerLookup.hasMessageHandler(messageType, beanType)) continue;
            found.add(beanName);
        }
        return found;
    }

    private static boolean hasMessageHandler(Class<? extends Message<?>> messageType, Class<?> beanType) {
        for (Method m : ReflectionUtils.methodsOf(beanType)) {
            Optional attr = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)m, MessageHandler.class);
            if (!attr.isPresent() || !messageType.isAssignableFrom((Class)((Map)attr.get()).get("messageType"))) continue;
            return true;
        }
        return false;
    }

    public void postProcessBeanFactory(@Nonnull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof BeanDefinitionRegistry)) {
            logger.warn("Given bean factory is not a BeanDefinitionRegistry. Cannot auto-configure message handlers");
            return;
        }
        for (MessageHandlerConfigurer.Type value : MessageHandlerConfigurer.Type.values()) {
            String configurerBeanName = "MessageHandlerConfigurer$$Axon$$" + value.name();
            if (beanFactory.containsBeanDefinition(configurerBeanName)) {
                logger.info("Message handler configurer already available. Skipping configuration");
                break;
            }
            List<String> found = MessageHandlerLookup.messageHandlerBeans(value.getMessageType(), beanFactory);
            if (found.isEmpty()) continue;
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(MessageHandlerConfigurer.class).addConstructorArgValue((Object)value.name()).addConstructorArgValue(found).getBeanDefinition();
            ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(configurerBeanName, (BeanDefinition)beanDefinition);
        }
    }

    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry registry) throws BeansException {
    }
}

