/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.NullLockFactory;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.AggregateConfigurer;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.DefaultConfigurer;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.config.ProcessingGroup;
import org.axonframework.config.TagsConfiguration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandler;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.GenericJpaRepository;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.spring.SpringUtils;
import org.axonframework.spring.config.AxonConfiguration;
import org.axonframework.spring.config.CommandHandlerSubscriber;
import org.axonframework.spring.config.ConfigurerFactoryBean;
import org.axonframework.spring.config.EventHandlerRegistrar;
import org.axonframework.spring.config.QueryHandlerSubscriber;
import org.axonframework.spring.config.RepositoryFactoryBean;
import org.axonframework.spring.config.annotation.SpringContextHandlerDefinitionBuilder;
import org.axonframework.spring.config.annotation.SpringContextParameterResolverFactoryBuilder;
import org.axonframework.spring.eventsourcing.SpringPrototypeAggregateFactory;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.axonframework.spring.saga.SpringResourceInjector;
import org.axonframework.spring.stereotype.Aggregate;
import org.axonframework.spring.stereotype.Saga;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringAxonAutoConfigurer
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware {
    public static final String AXON_CONFIGURATION_BEAN = "org.axonframework.spring.config.AxonConfiguration";
    public static final String AXON_CONFIGURER_BEAN = "org.axonframework.config.Configurer";
    private static final Logger logger = LoggerFactory.getLogger(SpringAxonAutoConfigurer.class);
    private static final String EMPTY_STRING = "";
    private ConfigurableListableBeanFactory beanFactory;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        registry.registerBeanDefinition("commandHandlerSubscriber", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(CommandHandlerSubscriber.class).getBeanDefinition());
        registry.registerBeanDefinition("queryHandlerSubscriber", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(QueryHandlerSubscriber.class).getBeanDefinition());
        Configurer configurer = DefaultConfigurer.defaultConfiguration((boolean)false);
        RuntimeBeanReference parameterResolver = SpringContextParameterResolverFactoryBuilder.getBeanReference(registry);
        configurer.registerComponent(ParameterResolverFactory.class, c -> (ParameterResolverFactory)this.beanFactory.getBean(parameterResolver.getBeanName(), ParameterResolverFactory.class));
        RuntimeBeanReference handlerDefinition = SpringContextHandlerDefinitionBuilder.getBeanReference(registry);
        configurer.registerHandlerDefinition((c, clazz) -> (HandlerDefinition)this.beanFactory.getBean(handlerDefinition.getBeanName(), HandlerDefinition.class));
        this.registerComponent(CommandBus.class, arg_0 -> ((Configurer)configurer).configureCommandBus(arg_0), configurer, Configuration::commandBus);
        this.registerComponent(QueryBus.class, arg_0 -> ((Configurer)configurer).configureQueryBus(arg_0), configurer, Configuration::queryBus);
        this.registerComponent(QueryUpdateEmitter.class, arg_0 -> ((Configurer)configurer).configureQueryUpdateEmitter(arg_0));
        this.registerComponent(EventStorageEngine.class, arg_0 -> ((Configurer)configurer).configureEmbeddedEventStore(arg_0), configurer, Configuration::eventBus);
        this.registerComponent(EventBus.class, arg_0 -> ((Configurer)configurer).configureEventBus(arg_0));
        this.registerComponent(Serializer.class, arg_0 -> ((Configurer)configurer).configureSerializer(arg_0));
        this.registerComponent(Serializer.class, "eventSerializer", arg_0 -> ((Configurer)configurer).configureEventSerializer(arg_0));
        this.registerComponent(Serializer.class, "messageSerializer", arg_0 -> ((Configurer)configurer).configureMessageSerializer(arg_0));
        this.registerComponent(TokenStore.class, configurer);
        try {
            this.findComponent(PlatformTransactionManager.class).ifPresent(ptm -> configurer.configureTransactionManager(c -> new SpringTransactionManager((PlatformTransactionManager)this.getBean((String)ptm, (Configuration)c))));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        this.registerComponent(TransactionManager.class, arg_0 -> ((Configurer)configurer).configureTransactionManager(arg_0));
        this.registerComponent(SagaStore.class, configurer);
        this.registerComponent(ListenerInvocationErrorHandler.class, configurer);
        this.registerComponent(ErrorHandler.class, configurer);
        this.registerComponent(TagsConfiguration.class, configurer);
        String resourceInjector = this.findComponent(ResourceInjector.class, registry, () -> BeanDefinitionBuilder.genericBeanDefinition(SpringResourceInjector.class).getBeanDefinition());
        configurer.configureResourceInjector(c -> (ResourceInjector)this.getBean(resourceInjector, (Configuration)c));
        this.registerComponent(EventScheduler.class, configurer, Configuration::eventScheduler);
        this.registerComponent(DeadlineManager.class, configurer, Configuration::deadlineManager);
        EventProcessingModule eventProcessingModule = new EventProcessingModule();
        Optional<String> eventProcessingConfigurerOptional = this.findComponent(EventProcessingConfigurer.class);
        String eventProcessingConfigurerBeanName = eventProcessingConfigurerOptional.orElse("eventProcessingConfigurer");
        if (!eventProcessingConfigurerOptional.isPresent()) {
            registry.registerBeanDefinition(eventProcessingConfigurerBeanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(EventProcessingConfigurer.class, () -> eventProcessingModule).getBeanDefinition());
        }
        this.registerModuleConfigurations(configurer);
        this.registerCorrelationDataProviders(configurer);
        this.registerEventUpcasters(configurer);
        this.registerAggregateBeanDefinitions(configurer, registry);
        String eventProcessingConfigurationName = this.findComponent(EventProcessingConfiguration.class).orElseThrow(() -> new AxonConfigurationException("Missing EventProcessingConfiguration bean"));
        registry.registerBeanDefinition(AXON_CONFIGURER_BEAN, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(ConfigurerFactoryBean.class).addConstructorArgValue((Object)configurer).getBeanDefinition());
        registry.registerBeanDefinition(AXON_CONFIGURATION_BEAN, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(AxonConfiguration.class).addConstructorArgReference(AXON_CONFIGURER_BEAN).getBeanDefinition());
        try {
            EventProcessingConfigurer eventProcessingConfigurer = configurer.eventProcessing();
            this.registerSagaBeanDefinitions(eventProcessingConfigurer);
            this.registerEventHandlerRegistrar(eventProcessingConfigurationName, eventProcessingConfigurerBeanName, registry);
        }
        catch (AxonConfigurationException ace) {
            logger.warn("There are several EventProcessingConfigurers registered, Axon will not automatically register sagas and event handlers.", (Throwable)ace);
        }
    }

    private void registerCorrelationDataProviders(Configurer configurer) {
        configurer.configureCorrelationDataProviders(c -> {
            String[] correlationDataProviderBeans = this.beanFactory.getBeanNamesForType(CorrelationDataProvider.class);
            return Arrays.stream(correlationDataProviderBeans).map(n -> (CorrelationDataProvider)this.getBean((String)n, (Configuration)c)).collect(Collectors.toList());
        });
    }

    private void registerEventUpcasters(Configurer configurer) {
        Arrays.stream(this.beanFactory.getBeanNamesForType(EventUpcaster.class)).forEach(name -> configurer.registerEventUpcaster(c -> (EventUpcaster)this.getBean((String)name, (Configuration)c)));
    }

    private <T> T getBean(String beanName, Configuration configuration) {
        return (T)((ApplicationContext)configuration.getComponent(ApplicationContext.class)).getBean(beanName);
    }

    private void registerEventHandlerRegistrar(String epConfigurationBeanName, String epConfigurerBeanName, BeanDefinitionRegistry registry) {
        ManagedList beans = new ManagedList();
        this.beanFactory.getBeanNamesIterator().forEachRemaining(arg_0 -> this.lambda$registerEventHandlerRegistrar$14((List)beans, arg_0));
        registry.registerBeanDefinition("eventHandlerRegistrar", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(EventHandlerRegistrar.class).addConstructorArgReference(AXON_CONFIGURATION_BEAN).addConstructorArgReference(epConfigurationBeanName).addConstructorArgReference(epConfigurerBeanName).addPropertyValue("eventHandlers", (Object)beans).getBeanDefinition());
    }

    private void registerModuleConfigurations(Configurer configurer) {
        String[] moduleConfigurations;
        for (String moduleConfiguration : moduleConfigurations = this.beanFactory.getBeanNamesForType(ModuleConfiguration.class)) {
            configurer.registerModule((ModuleConfiguration)new LazyRetrievedModuleConfiguration(() -> (ModuleConfiguration)this.beanFactory.getBean(moduleConfiguration, ModuleConfiguration.class), this.beanFactory.getType(moduleConfiguration)));
        }
    }

    private void registerSagaBeanDefinitions(EventProcessingConfigurer configurer) {
        String[] sagas;
        for (String saga : sagas = this.beanFactory.getBeanNamesForAnnotation(Saga.class)) {
            Saga sagaAnnotation = (Saga)this.beanFactory.findAnnotationOnBean(saga, Saga.class);
            Class sagaType = this.beanFactory.getType(saga);
            ProcessingGroup processingGroupAnnotation = (ProcessingGroup)this.beanFactory.findAnnotationOnBean(saga, ProcessingGroup.class);
            if (processingGroupAnnotation != null && this.nonEmptyBeanName(processingGroupAnnotation.value())) {
                configurer.assignHandlerTypesMatching(processingGroupAnnotation.value(), sagaType::equals);
            }
            configurer.registerSaga(sagaType, sagaConfigurer -> {
                if (sagaAnnotation != null && this.nonEmptyBeanName(sagaAnnotation.sagaStore())) {
                    sagaConfigurer.configureSagaStore(c -> (SagaStore)this.beanFactory.getBean(sagaAnnotation.sagaStore(), SagaStore.class));
                }
            });
        }
    }

    private <A> Map<SpringAggregate<? super A>, Map<Class<? extends A>, String>> buildAggregateHierarchy(String[] aggregatePrototypes) {
        HashMap<SpringAggregate<A>, Map<Class<A>, String>> hierarchy = new HashMap<SpringAggregate<A>, Map<Class<A>, String>>();
        for (String prototype : aggregatePrototypes) {
            Class aggregateType = this.beanFactory.getType(prototype);
            SpringAggregate springAggregate = new SpringAggregate(prototype, aggregateType);
            Class<A> topType = this.topAnnotatedAggregateType(aggregateType);
            SpringAggregate topSpringAggregate = new SpringAggregate(this.beanName(topType), topType);
            hierarchy.compute(topSpringAggregate, (type, subtypes) -> {
                if (subtypes == null) {
                    subtypes = new HashMap<Class, String>();
                }
                if (!type.equals(springAggregate)) {
                    subtypes.put(aggregateType, prototype);
                }
                return subtypes;
            });
        }
        return hierarchy;
    }

    private <A> String beanName(Class<A> type) {
        String[] beanNamesForType = this.beanFactory.getBeanNamesForType(type);
        if (beanNamesForType.length == 0) {
            throw new AxonConfigurationException(String.format("There are no spring beans for '%s' defined.", type.getName()));
        }
        if (beanNamesForType.length != 1) {
            logger.warn("There are {} beans defined for '{}'.", (Object)beanNamesForType.length, (Object)type.getName());
        }
        return beanNamesForType[0];
    }

    private <A> Class<? super A> topAnnotatedAggregateType(Class<A> type) {
        Class<A> top;
        Class<A> topAnnotated = top = type;
        while (!top.getSuperclass().equals(Object.class)) {
            if (!(top = top.getSuperclass()).isAnnotationPresent(Aggregate.class)) continue;
            topAnnotated = top;
        }
        return topAnnotated;
    }

    private <A> void registerAggregateBeanDefinitions(Configurer configurer, BeanDefinitionRegistry registry) {
        String[] aggregates = this.beanFactory.getBeanNamesForAnnotation(Aggregate.class);
        Map<SpringAggregate<A>, Map<Class<A>, String>> hierarchy = this.buildAggregateHierarchy(aggregates);
        for (Map.Entry<SpringAggregate<A>, Map<Class<A>, String>> aggregate : hierarchy.entrySet()) {
            String commandTargetResolverBeanName;
            Class<Aggregate> aggregateType = aggregate.getKey().getClassType();
            String aggregatePrototype = aggregate.getKey().getBeanName();
            Aggregate aggregateAnnotation = aggregateType.getAnnotation(Aggregate.class);
            AggregateConfigurer aggregateConfigurer = AggregateConfigurer.defaultConfiguration(aggregateType);
            aggregateConfigurer.withSubtypes(aggregate.getValue().keySet());
            if (EMPTY_STRING.equals(aggregateAnnotation.repository())) {
                String repositoryName = this.lcFirst(aggregateType.getSimpleName()) + "Repository";
                String factoryName = aggregatePrototype.substring(0, 1).toLowerCase() + aggregatePrototype.substring(1) + "AggregateFactory";
                if (this.beanFactory.containsBean(repositoryName)) {
                    aggregateConfigurer.configureRepository(c -> (Repository)this.beanFactory.getBean(repositoryName, Repository.class));
                } else {
                    String cacheBeanName;
                    registry.registerBeanDefinition(repositoryName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(RepositoryFactoryBean.class).addConstructorArgValue((Object)aggregateConfigurer).getBeanDefinition());
                    if (!registry.isBeanNameInUse(factoryName)) {
                        registry.registerBeanDefinition(factoryName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SpringPrototypeAggregateFactory.class).addConstructorArgValue((Object)aggregatePrototype).addConstructorArgValue(aggregate.getValue()).getBeanDefinition());
                    }
                    aggregateConfigurer.configureAggregateFactory(c -> (AggregateFactory)this.beanFactory.getBean(factoryName, AggregateFactory.class));
                    String triggerDefinitionBeanName = aggregateAnnotation.snapshotTriggerDefinition();
                    if (this.nonEmptyBeanName(triggerDefinitionBeanName)) {
                        aggregateConfigurer.configureSnapshotTrigger(c -> (SnapshotTriggerDefinition)this.beanFactory.getBean(triggerDefinitionBeanName, SnapshotTriggerDefinition.class));
                    }
                    if (this.nonEmptyBeanName(cacheBeanName = aggregateAnnotation.cache())) {
                        aggregateConfigurer.configureCache(c -> (Cache)this.beanFactory.getBean(cacheBeanName, Cache.class));
                    }
                    if (AnnotationUtils.isAnnotationPresent(aggregateType, (String)"javax.persistence.Entity")) {
                        aggregateConfigurer.configureRepository(c -> GenericJpaRepository.builder((Class)aggregateType).parameterResolverFactory(c.parameterResolverFactory()).handlerDefinition(c.handlerDefinition(aggregateType)).lockFactory((LockFactory)c.getComponent(LockFactory.class, () -> NullLockFactory.INSTANCE)).entityManagerProvider((EntityManagerProvider)c.getComponent(EntityManagerProvider.class, () -> (EntityManagerProvider)this.beanFactory.getBean(EntityManagerProvider.class))).eventBus(c.eventBus()).repositoryProvider(arg_0 -> ((Configuration)c).repository(arg_0)).build());
                    }
                }
            } else {
                aggregateConfigurer.configureRepository(c -> (Repository)this.beanFactory.getBean(aggregateAnnotation.repository(), Repository.class));
            }
            String snapshotFilterBeanName = aggregateAnnotation.snapshotFilter();
            if (this.nonEmptyBeanName(snapshotFilterBeanName)) {
                aggregateConfigurer.configureSnapshotFilter(c -> (SnapshotFilter)this.getBean(snapshotFilterBeanName, (Configuration)c));
            }
            if (this.nonEmptyBeanName(commandTargetResolverBeanName = aggregateAnnotation.commandTargetResolver())) {
                aggregateConfigurer.configureCommandTargetResolver(c -> (CommandTargetResolver)this.getBean(commandTargetResolverBeanName, (Configuration)c));
            } else {
                this.findComponent(CommandTargetResolver.class).ifPresent(commandTargetResolver -> aggregateConfigurer.configureCommandTargetResolver(c -> (CommandTargetResolver)this.getBean((String)commandTargetResolver, (Configuration)c)));
            }
            aggregateConfigurer.configureFilterEventsByType(c -> aggregateAnnotation.filterEventsByType());
            configurer.configureAggregate((AggregateConfiguration)aggregateConfigurer);
        }
    }

    private boolean nonEmptyBeanName(String beanName) {
        return !EMPTY_STRING.equals(beanName);
    }

    private String lcFirst(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    private <T> String findComponent(Class<T> componentType, BeanDefinitionRegistry registry, Supplier<BeanDefinition> defaultBean) {
        return this.findComponent(componentType).orElseGet(() -> {
            BeanDefinition beanDefinition = (BeanDefinition)defaultBean.get();
            String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
            registry.registerBeanDefinition(beanName, beanDefinition);
            return beanName;
        });
    }

    private <T> void registerComponent(Class<T> componentType, String componentQualifier, Consumer<Function<Configuration, T>> registrationFunction) {
        this.findComponent(componentType, componentQualifier).ifPresent(componentName -> registrationFunction.accept(config -> this.getBean((String)componentName, (Configuration)config)));
    }

    private <T> Optional<String> findComponent(Class<T> componentType, String componentQualifier) {
        return Stream.of(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, componentType)).filter(bean -> SpringUtils.isQualifierMatch(bean, this.beanFactory, componentQualifier)).findFirst();
    }

    private <T> void registerComponent(Class<T> componentType, Consumer<Function<Configuration, T>> registrationFunction) {
        this.findComponent(componentType).ifPresent(componentName -> registrationFunction.accept(config -> this.getBean((String)componentName, (Configuration)config)));
    }

    private <T> void registerComponent(Class<T> componentType, Configurer configurer) {
        this.registerComponent(componentType, builder -> configurer.registerComponent(componentType, builder), configurer, null);
    }

    private <T> void registerComponent(Class<T> componentType, Configurer configurer, Consumer<Configuration> initHandler) {
        this.registerComponent(componentType, builder -> configurer.registerComponent(componentType, builder), configurer, initHandler);
    }

    private <T> void registerComponent(Class<T> componentType, Consumer<Function<Configuration, T>> registrationFunction, Configurer configurer, Consumer<Configuration> initHandler) {
        this.findComponent(componentType).ifPresent(componentName -> {
            registrationFunction.accept(config -> this.getBean((String)componentName, (Configuration)config));
            if (initHandler != null) {
                configurer.onInitialize(c -> c.onStart(Integer.MIN_VALUE, () -> initHandler.accept((Configuration)c)));
            }
        });
    }

    private <T> Optional<String> findComponent(Class<T> componentType) {
        String[] beans = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, componentType);
        if (beans.length == 1) {
            return Optional.of(beans[0]);
        }
        if (beans.length > 1) {
            for (String bean : beans) {
                BeanDefinition beanDef = this.beanFactory.getMergedBeanDefinition(bean);
                if (!beanDef.isPrimary()) continue;
                return Optional.of(bean);
            }
            logger.warn("Multiple beans of type {} found in application context: {}. Chose {}", new Object[]{componentType.getSimpleName(), beans, beans[0]});
            return Optional.of(beans[0]);
        }
        return Optional.empty();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    private /* synthetic */ void lambda$registerEventHandlerRegistrar$14(List beans, String bean) {
        boolean hasHandler;
        Class beanType;
        if (!this.beanFactory.isFactoryBean(bean) && (beanType = this.beanFactory.getType(bean)) != null && this.beanFactory.containsBeanDefinition(bean) && this.beanFactory.getBeanDefinition(bean).isSingleton() && (hasHandler = StreamSupport.stream(ReflectionUtils.methodsOf((Class)beanType).spliterator(), false).map(m -> AnnotationUtils.findAnnotationAttributes((AnnotatedElement)m, MessageHandler.class).orElse(null)).filter(Objects::nonNull).anyMatch(attr -> EventMessage.class.isAssignableFrom((Class)attr.get("messageType"))))) {
            beans.add(new RuntimeBeanReference(bean));
        }
    }

    private static class SpringAggregate<T> {
        private final String beanName;
        private final Class<T> classType;

        private SpringAggregate(String beanName, Class<T> classType) {
            this.beanName = beanName;
            this.classType = classType;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public Class<T> getClassType() {
            return this.classType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpringAggregate that = (SpringAggregate)o;
            return Objects.equals(this.beanName, that.beanName) && Objects.equals(this.classType, that.classType);
        }

        public int hashCode() {
            return Objects.hash(this.beanName, this.classType);
        }
    }

    private static class LazyRetrievedModuleConfiguration
    implements ModuleConfiguration {
        private final Supplier<ModuleConfiguration> delegateSupplier;
        private final Class<?> moduleType;
        private ModuleConfiguration delegate;

        LazyRetrievedModuleConfiguration(Supplier<ModuleConfiguration> delegateSupplier, Class<?> moduleType) {
            this.delegateSupplier = delegateSupplier;
            this.moduleType = moduleType;
        }

        public void initialize(Configuration config) {
            this.getDelegate().initialize(config);
        }

        public ModuleConfiguration unwrap() {
            return this.getDelegate();
        }

        public boolean isType(Class<?> type) {
            return type.isAssignableFrom(this.moduleType);
        }

        private ModuleConfiguration getDelegate() {
            if (this.delegate == null) {
                this.delegate = this.delegateSupplier.get();
            }
            return this.delegate;
        }
    }

    public static class ImportSelector
    implements DeferredImportSelector {
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            return new String[]{SpringAxonAutoConfigurer.class.getName()};
        }
    }
}

