/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventsourcing;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.axonframework.commandhandling.model.RepositoryProvider;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.AggregateSnapshotter;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringAggregateSnapshotter
extends AggregateSnapshotter
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public SpringAggregateSnapshotter(EventStore eventStore, ParameterResolverFactory parameterResolverFactory, Executor executor, TransactionManager txManager) {
        super(eventStore, Collections.emptyList(), parameterResolverFactory, executor, txManager);
    }

    public SpringAggregateSnapshotter(EventStore eventStore, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Executor executor, TransactionManager txManager, RepositoryProvider repositoryProvider) {
        super(eventStore, Collections.emptyList(), parameterResolverFactory, handlerDefinition, executor, txManager, repositoryProvider);
    }

    protected AggregateFactory<?> getAggregateFactory(Class<?> aggregateType) {
        AggregateFactory aggregateFactory = super.getAggregateFactory(aggregateType);
        if (aggregateFactory == null) {
            Optional<AggregateFactory> factory = this.applicationContext.getBeansOfType(AggregateFactory.class).values().stream().filter(af -> Objects.equals(af.getAggregateType(), aggregateType)).findFirst();
            if (!factory.isPresent() && (factory = this.applicationContext.getBeansOfType(EventSourcingRepository.class).values().stream().map(EventSourcingRepository::getAggregateFactory).filter(af -> Objects.equals(af.getAggregateType(), aggregateType)).findFirst()).isPresent()) {
                aggregateFactory = factory.get();
                this.registerAggregateFactory(aggregateFactory);
            }
            if (factory.isPresent()) {
                aggregateFactory = factory.get();
                this.registerAggregateFactory(aggregateFactory);
            }
        }
        return aggregateFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

