/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.List;
import java.util.function.Supplier;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.commandhandling.model.Repository;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.saga.ResourceInjector;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcasterChain;
import org.axonframework.spring.config.NoBeanOfType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@org.springframework.context.annotation.Configuration(value="org.axonframework.spring.config.AxonConfiguration")
public class AxonConfiguration
implements Configuration,
InitializingBean,
ApplicationContextAware,
SmartLifecycle {
    private final Configurer configurer;
    private Configuration config;
    private volatile boolean running = false;

    public AxonConfiguration(Configurer configurer) {
        this.configurer = configurer;
    }

    public CommandBus commandBus() {
        return this.config.commandBus();
    }

    public QueryBus queryBus() {
        return this.config.queryBus();
    }

    public EventBus eventBus() {
        return this.config.eventBus();
    }

    public QueryUpdateEmitter queryUpdateEmitter() {
        return this.config.queryUpdateEmitter();
    }

    @NoBeanOfType(value=QueryBus.class)
    @Bean(value={"queryBus"})
    @Primary
    public QueryBus defaultQueryBus() {
        return this.config.queryBus();
    }

    @NoBeanOfType(value=QueryUpdateEmitter.class)
    @Bean(value={"queryUpdateEmitter"})
    public QueryUpdateEmitter defaultQueryUpdateEmitter() {
        return this.config.queryUpdateEmitter();
    }

    @NoBeanOfType(value=CommandBus.class)
    @Bean(value={"commandBus"})
    public CommandBus defaultCommandBus() {
        return this.commandBus();
    }

    @NoBeanOfType(value=EventBus.class)
    @Bean(value={"eventBus"})
    public EventBus defaultEventBus() {
        return this.eventBus();
    }

    public ResourceInjector resourceInjector() {
        return this.config.resourceInjector();
    }

    @NoBeanOfType(value=CommandGateway.class)
    @Bean
    public CommandGateway commandGateway(CommandBus commandBus) {
        return new DefaultCommandGateway(commandBus, new MessageDispatchInterceptor[0]);
    }

    @NoBeanOfType(value=QueryGateway.class)
    @Bean
    public QueryGateway queryGateway(QueryBus queryBus) {
        return new DefaultQueryGateway(queryBus, new MessageDispatchInterceptor[0]);
    }

    public <T> Repository<T> repository(Class<T> aggregateType) {
        return this.config.repository(aggregateType);
    }

    public <T> T getComponent(Class<T> componentType, Supplier<T> defaultImpl) {
        return (T)this.config.getComponent(componentType, defaultImpl);
    }

    public <M extends Message<?>> MessageMonitor<? super M> messageMonitor(Class<?> componentType, String componentName) {
        return this.config.messageMonitor(componentType, componentName);
    }

    public Serializer eventSerializer() {
        return this.config.eventSerializer();
    }

    public Serializer messageSerializer() {
        return this.config.messageSerializer();
    }

    public List<CorrelationDataProvider> correlationDataProviders() {
        return this.config.correlationDataProviders();
    }

    public HandlerDefinition handlerDefinition(Class<?> inspectedType) {
        return this.config.handlerDefinition(inspectedType);
    }

    public EventUpcasterChain upcasterChain() {
        return this.config.upcasterChain();
    }

    public List<ModuleConfiguration> getModules() {
        return this.config.getModules();
    }

    public void onStart(int phase, Runnable startHandler) {
        this.config.onStart(phase, startHandler);
    }

    public void onShutdown(int phase, Runnable shutdownHandler) {
        this.config.onShutdown(phase, shutdownHandler);
    }

    public void start() {
        this.config.start();
        this.running = true;
    }

    public void shutdown() {
        this.config.shutdown();
    }

    public void stop() {
        this.shutdown();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return 0;
    }

    public void afterPropertiesSet() {
        this.config = this.configurer.buildConfiguration();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.configurer.registerComponent(ApplicationContext.class, c -> applicationContext);
    }
}

