/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.spring.messaging.DefaultEventMessageConverter;
import org.axonframework.spring.messaging.EventMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;

public class InboundEventMessageChannelAdapter
implements MessageHandler,
SubscribableMessageSource<EventMessage<?>> {
    private final CopyOnWriteArrayList<Consumer<List<? extends EventMessage<?>>>> messageProcessors = new CopyOnWriteArrayList();
    private final EventMessageConverter eventMessageConverter;

    public InboundEventMessageChannelAdapter() {
        this(Collections.emptyList(), new DefaultEventMessageConverter());
    }

    public InboundEventMessageChannelAdapter(EventBus eventBus) {
        this(Collections.singletonList(arg_0 -> ((EventBus)eventBus).publish(arg_0)), new DefaultEventMessageConverter());
    }

    public InboundEventMessageChannelAdapter(List<Consumer<List<? extends EventMessage<?>>>> processors, EventMessageConverter eventMessageConverter) {
        processors.forEach(this.messageProcessors::add);
        this.eventMessageConverter = eventMessageConverter;
    }

    public Registration subscribe(Consumer<List<? extends EventMessage<?>>> messageProcessor) {
        this.messageProcessors.add(messageProcessor);
        return () -> this.messageProcessors.remove(messageProcessor);
    }

    public void handleMessage(Message<?> message) {
        List<EventMessage<?>> messages = Collections.singletonList(this.transformMessage(message));
        for (Consumer<List<EventMessage<?>>> messageProcessor : this.messageProcessors) {
            messageProcessor.accept(messages);
        }
    }

    protected EventMessage<?> transformMessage(Message<?> message) {
        return this.eventMessageConverter.convertFromInboundMessage(message);
    }
}

