/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.connector.AxonServerConnection;
import io.axoniq.axonserver.connector.FlowControl;
import io.axoniq.axonserver.connector.ReplyChannel;
import io.axoniq.axonserver.connector.ResultStream;
import io.axoniq.axonserver.connector.query.QueryDefinition;
import io.axoniq.axonserver.connector.query.QueryHandler;
import io.axoniq.axonserver.connector.query.SubscriptionQueryResult;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryUpdate;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.query.FlowControlledResponseSender;
import org.axonframework.axonserver.connector.query.QueryConverter;
import org.axonframework.axonserver.connector.query.QueryResponseMessageStream;
import org.axonframework.axonserver.connector.query.QueryUpdateMessageStream;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.Registration;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.lifecycle.ShutdownLatch;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.QueryResponseMessage;
import org.axonframework.messaging.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.messaging.queryhandling.distributed.QueryBusConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxonServerQueryBusConnector
implements QueryBusConnector {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AxonServerConnection connection;
    private final String clientId;
    private final String componentName;
    private final LocalSegmentAdapter localSegmentAdapter;
    private final Map<QualifiedName, io.axoniq.axonserver.connector.Registration> subscriptions = new ConcurrentHashMap<QualifiedName, io.axoniq.axonserver.connector.Registration>();
    private final ShutdownLatch shutdownLatch = new ShutdownLatch();
    private final Duration queryInProgressAwait = Duration.ofSeconds(5L);
    private QueryBusConnector.Handler incomingHandler;

    public AxonServerQueryBusConnector(@Nonnull AxonServerConnection connection, @Nonnull AxonServerConfiguration configuration) {
        this.connection = Objects.requireNonNull(connection, "The AxonServerConnection must not be null.");
        Objects.requireNonNull(configuration, "The AxonServerConfiguration must not be null.");
        this.clientId = configuration.getClientId();
        this.componentName = configuration.getComponentName();
        this.localSegmentAdapter = new LocalSegmentAdapter();
    }

    public void start() {
        this.shutdownLatch.initialize();
        logger.trace("The AxonServerQueryBusConnector started.");
    }

    public CompletableFuture<Void> subscribe(@Nonnull QualifiedName name) {
        logger.debug("Subscribing to query handler [{}].", (Object)name);
        QueryDefinition definition = new QueryDefinition(name.fullName(), "");
        io.axoniq.axonserver.connector.Registration registration = this.connection.queryChannel().registerQueryHandler((QueryHandler)this.localSegmentAdapter, new QueryDefinition[]{definition});
        this.subscriptions.put(name, registration);
        CompletableFuture<Void> completion = new CompletableFuture<Void>();
        registration.onAck(() -> completion.complete(null));
        return completion;
    }

    public boolean unsubscribe(@Nonnull QualifiedName name) {
        io.axoniq.axonserver.connector.Registration subscription = this.subscriptions.remove(name);
        if (subscription != null) {
            subscription.cancel();
            return true;
        }
        return false;
    }

    public void onIncomingQuery(@Nonnull QueryBusConnector.Handler handler) {
        this.incomingHandler = Objects.requireNonNull(handler, "The incoming query handler must not be null.");
    }

    @Nonnull
    public MessageStream<QueryResponseMessage> query(@Nonnull QueryMessage query, @Nullable ProcessingContext context) {
        this.shutdownLatch.ifShuttingDown("Cannot dispatch new queries as this bus is being shut down");
        try (ShutdownLatch.ActivityHandle queryInTransit = this.shutdownLatch.registerActivity();){
            ResultStream resultStream = this.connection.queryChannel().query(QueryConverter.convertQueryMessage(query, this.clientId, this.componentName));
            MessageStream messageStream = new QueryResponseMessageStream((ResultStream<QueryResponse>)resultStream).onClose(() -> ((ShutdownLatch.ActivityHandle)queryInTransit).end());
            return messageStream;
        }
    }

    @Nonnull
    public MessageStream<QueryResponseMessage> subscriptionQuery(@Nonnull QueryMessage query, @Nullable ProcessingContext context, int updateBufferSize) {
        this.shutdownLatch.ifShuttingDown("Cannot dispatch new queries as this bus is being shut down");
        try (ShutdownLatch.ActivityHandle queryInTransit = this.shutdownLatch.registerActivity();){
            SubscriptionQueryResult result = this.connection.queryChannel().subscriptionQuery(QueryConverter.convertQueryMessage(query, this.clientId, this.componentName), updateBufferSize, Math.min(updateBufferSize / 4, 8));
            MessageStream messageStream = new QueryResponseMessageStream((ResultStream<QueryResponse>)result.initialResults()).concatWith(new QueryUpdateMessageStream((ResultStream<QueryUpdate>)result.updates())).onClose(() -> ((ShutdownLatch.ActivityHandle)queryInTransit).end());
            return messageStream;
        }
    }

    public CompletableFuture<Void> disconnect() {
        if (this.connection.isConnected()) {
            logger.trace("Disconnecting the AxonServerQueryBusConnector.");
            this.connection.queryChannel().prepareDisconnect();
        }
        if (!this.localSegmentAdapter.awaitTermination(this.queryInProgressAwait)) {
            logger.info("Awaited termination of queries in progress without success. Going to cancel remaining queries in progress.");
            this.localSegmentAdapter.cancel();
        }
        return FutureUtils.emptyCompletedFuture();
    }

    public CompletableFuture<Void> shutdownDispatching() {
        logger.trace("Shutting down dispatching of AxonServerQueryBusConnector.");
        return this.shutdownLatch.initiateShutdown();
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("connection", (Object)this.connection);
        descriptor.describeProperty("clientId", this.clientId);
        descriptor.describeProperty("componentName", this.componentName);
    }

    private class LocalSegmentAdapter
    implements QueryHandler {
        private final Map<String, Runnable> queriesInProgress = new ConcurrentHashMap<String, Runnable>();

        private LocalSegmentAdapter() {
        }

        public void handle(QueryRequest query, ReplyChannel<QueryResponse> responseHandler) {
            this.stream(query, responseHandler).request(Long.MAX_VALUE);
        }

        public FlowControl stream(QueryRequest query, ReplyChannel<QueryResponse> responseHandler) {
            MessageStream result = AxonServerQueryBusConnector.this.incomingHandler.query(QueryConverter.convertQueryRequest(query));
            Runnable previous = this.queriesInProgress.put(query.getMessageIdentifier(), () -> ((MessageStream)result).close());
            if (previous != null) {
                previous.run();
            }
            return new FlowControlledResponseSender(AxonServerQueryBusConnector.this.clientId, query.getMessageIdentifier(), (MessageStream<QueryResponseMessage>)result.onClose(this.queriesInProgress.remove(query.getMessageIdentifier())), responseHandler);
        }

        public io.axoniq.axonserver.connector.Registration registerSubscriptionQuery(SubscriptionQuery query, QueryHandler.UpdateHandler sendUpdate) {
            Registration registration = AxonServerQueryBusConnector.this.incomingHandler.registerUpdateHandler(QueryConverter.convertSubscriptionQueryMessage(query), (QueryBusConnector.UpdateCallback)new AxonServerUpdateCallback(sendUpdate));
            return () -> {
                registration.cancel();
                return FutureUtils.emptyCompletedFuture();
            };
        }

        private boolean awaitTermination(Duration timeout) {
            Instant startAwait = Instant.now();
            Instant endAwait = startAwait.plusSeconds(timeout.getSeconds());
            while (Instant.now().isBefore(endAwait) && !this.queriesInProgress.isEmpty()) {
                this.queriesInProgress.values().stream().findFirst().ifPresent(queryInProgress -> {
                    while (Instant.now().isBefore(endAwait)) {
                        LockSupport.parkNanos(10000000L);
                    }
                });
            }
            return this.queriesInProgress.isEmpty();
        }

        private void cancel() {
            this.queriesInProgress.values().iterator().forEachRemaining(Runnable::run);
        }
    }

    class AxonServerUpdateCallback
    implements QueryBusConnector.UpdateCallback {
        private final QueryHandler.UpdateHandler updateHandler;

        public AxonServerUpdateCallback(QueryHandler.UpdateHandler updateHandler) {
            this.updateHandler = updateHandler;
        }

        @Nonnull
        public CompletableFuture<Void> sendUpdate(@Nonnull SubscriptionQueryUpdateMessage update) {
            this.updateHandler.sendUpdate(QueryConverter.convertQueryUpdate(update));
            return FutureUtils.emptyCompletedFuture();
        }

        public CompletableFuture<Void> complete() {
            this.updateHandler.complete();
            return FutureUtils.emptyCompletedFuture();
        }

        public CompletableFuture<Void> completeExceptionally(@Nonnull Throwable error) {
            this.updateHandler.sendUpdate(QueryConverter.convertQueryUpdate(AxonServerQueryBusConnector.this.clientId, ErrorCode.QUERY_EXECUTION_ERROR, error));
            this.updateHandler.complete();
            return FutureUtils.emptyCompletedFuture();
        }
    }
}

