/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.ManagedChannelCustomizer;
import org.axonframework.axonserver.connector.TagsConfiguration;
import org.axonframework.axonserver.connector.TopologyChangeListener;
import org.axonframework.axonserver.connector.command.AxonServerCommandBusConnector;
import org.axonframework.axonserver.connector.event.AxonServerEventStorageEngineFactory;
import org.axonframework.axonserver.connector.event.EventProcessorControlService;
import org.axonframework.axonserver.connector.query.AxonServerQueryBusConnector;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.PayloadConvertingCommandBusConnector;
import org.axonframework.common.FutureUtils;
import org.axonframework.configuration.ComponentDecorator;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.configuration.DecoratorDefinition;
import org.axonframework.configuration.SearchScope;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.queryhandling.distributed.PayloadConvertingQueryBusConnector;
import org.axonframework.queryhandling.distributed.QueryBusConnector;

public class AxonServerConfigurationEnhancer
implements ConfigurationEnhancer {
    public static final int ENHANCER_ORDER = -2147483638;

    public void enhance(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(AxonServerConfiguration.class, c -> new AxonServerConfiguration(), SearchScope.ALL).registerIfNotPresent(AxonServerConfigurationEnhancer.connectionManagerDefinition(), SearchScope.ALL).registerIfNotPresent(ManagedChannelCustomizer.class, c -> ManagedChannelCustomizer.identity(), SearchScope.ALL).registerIfNotPresent(AxonServerConfigurationEnhancer.eventStorageEngineDefinition(), SearchScope.ALL).registerIfNotPresent(AxonServerConfigurationEnhancer.commandBusConnectorDefinition(), SearchScope.ALL).registerIfNotPresent(AxonServerConfigurationEnhancer.queryBusConnectorDefinition(), SearchScope.ALL).registerDecorator(CommandBusConnector.class, 0, AxonServerConfigurationEnhancer.payloadConvertingConnectorComponentDecorator()).registerDecorator(QueryBusConnector.class, 0, AxonServerConfigurationEnhancer.payloadConvertingQueryBusConnectorComponentDecorator()).registerDecorator(AxonServerConfigurationEnhancer.topologyChangeListenerRegistration()).registerFactory((ComponentFactory)new AxonServerEventStorageEngineFactory()).registerIfNotPresent(AxonServerConfigurationEnhancer.eventProcessorControlService());
    }

    private static ComponentDefinition<AxonServerConnectionManager> connectionManagerDefinition() {
        return ComponentDefinition.ofType(AxonServerConnectionManager.class).withBuilder(AxonServerConfigurationEnhancer::buildConnectionManager).onStart(0x40000009, AxonServerConnectionManager::start).onShutdown(-134217728, AxonServerConnectionManager::shutdown);
    }

    private static AxonServerConnectionManager buildConnectionManager(Configuration config) {
        AxonServerConfiguration serverConfig = (AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class);
        return AxonServerConnectionManager.builder().routingServers(serverConfig.getServers()).axonServerConfiguration(serverConfig).tagsConfiguration((TagsConfiguration)config.getComponent(TagsConfiguration.class, TagsConfiguration::new)).channelCustomizer((UnaryOperator)config.getComponent(ManagedChannelCustomizer.class)).build();
    }

    private static ComponentDefinition<EventStorageEngine> eventStorageEngineDefinition() {
        return ComponentDefinition.ofType(EventStorageEngine.class).withBuilder(config -> {
            String defaultContext = ((AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class)).getContext();
            return AxonServerEventStorageEngineFactory.constructForContext(defaultContext, config);
        });
    }

    private static ComponentDefinition<CommandBusConnector> commandBusConnectorDefinition() {
        return ComponentDefinition.ofType(CommandBusConnector.class).withBuilder(config -> new AxonServerCommandBusConnector(((AxonServerConnectionManager)config.getComponent(AxonServerConnectionManager.class)).getConnection(), (AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class))).onStart(0x1FFFFFFF, connector -> ((AxonServerCommandBusConnector)connector).start()).onShutdown(0x1FFFFFFF, (config, connector) -> ((AxonServerCommandBusConnector)connector).disconnect()).onShutdown(0, (config, connector) -> ((AxonServerCommandBusConnector)connector).shutdownDispatching());
    }

    private static ComponentDefinition<QueryBusConnector> queryBusConnectorDefinition() {
        return ComponentDefinition.ofType(QueryBusConnector.class).withBuilder(config -> new AxonServerQueryBusConnector(((AxonServerConnectionManager)config.getComponent(AxonServerConnectionManager.class)).getConnection(), (AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class))).onStart(0x1FFFFFFF, connector -> ((AxonServerQueryBusConnector)connector).start()).onShutdown(0x1FFFFFFF, (config, connector) -> ((AxonServerQueryBusConnector)connector).disconnect()).onShutdown(0, (config, connector) -> ((AxonServerQueryBusConnector)connector).shutdownDispatching());
    }

    private static ComponentDecorator<QueryBusConnector, PayloadConvertingQueryBusConnector> payloadConvertingQueryBusConnectorComponentDecorator() {
        return (config, name, delegate) -> new PayloadConvertingQueryBusConnector(delegate, (MessageConverter)config.getComponent(MessageConverter.class), byte[].class);
    }

    private static ComponentDecorator<CommandBusConnector, PayloadConvertingCommandBusConnector> payloadConvertingConnectorComponentDecorator() {
        return (config, name, delegate) -> new PayloadConvertingCommandBusConnector(delegate, (MessageConverter)config.getComponent(MessageConverter.class), byte[].class);
    }

    private static DecoratorDefinition<AxonServerConnectionManager, AxonServerConnectionManager> topologyChangeListenerRegistration() {
        return DecoratorDefinition.forType(AxonServerConnectionManager.class).with((config, name, delegate) -> delegate).onStart(0x40000009, (config, connectionManager) -> {
            Optional topologyChangeListener = config.getOptionalComponent(TopologyChangeListener.class);
            topologyChangeListener.ifPresent(changeListener -> connectionManager.getConnection().controlChannel().registerTopologyChangeHandler((Consumer)changeListener));
            return FutureUtils.emptyCompletedFuture();
        });
    }

    private static ComponentDefinition<EventProcessorControlService> eventProcessorControlService() {
        return ComponentDefinition.ofType(EventProcessorControlService.class).withBuilder(c -> {
            AxonServerConfiguration serverConfig = (AxonServerConfiguration)c.getComponent(AxonServerConfiguration.class);
            return new EventProcessorControlService(c, (AxonServerConnectionManager)c.getComponent(AxonServerConnectionManager.class), serverConfig.getContext(), serverConfig.getEventhandling().getProcessors());
        }).onStart(0x40000009, EventProcessorControlService::start);
    }

    public int order() {
        return -2147483638;
    }
}

