/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor.grpc;

import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.processor.EventProcessorInfoSource;
import org.axonframework.axonserver.connector.processor.grpc.EventProcessors;
import org.axonframework.axonserver.connector.processor.grpc.GrpcEventProcessorMapping;
import org.axonframework.axonserver.connector.processor.grpc.PlatformInboundMessage;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.EventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcEventProcessorInfoSource
implements EventProcessorInfoSource {
    private static final Logger logger = LoggerFactory.getLogger(GrpcEventProcessorInfoSource.class);
    private final EventProcessors eventProcessors;
    private final Consumer<PlatformInboundInstruction> platformInstructionSender;
    private final Function<EventProcessor, PlatformInboundMessage> platformInboundMessageMapper;
    private final Map<String, PlatformInboundInstruction> lastProcessorsInfo;
    private final AtomicBoolean logError = new AtomicBoolean(true);

    public GrpcEventProcessorInfoSource(EventProcessingConfiguration eventProcessingConfiguration, AxonServerConnectionManager axonServerConnectionManager, String context) {
        this(new EventProcessors(eventProcessingConfiguration), (PlatformInboundInstruction instruction) -> axonServerConnectionManager.send(context, (PlatformInboundInstruction)instruction), new GrpcEventProcessorMapping());
        axonServerConnectionManager.addReconnectListener(context, this.lastProcessorsInfo::clear);
    }

    private GrpcEventProcessorInfoSource(EventProcessors eventProcessors, Consumer<PlatformInboundInstruction> platformInstructionSender, Function<EventProcessor, PlatformInboundMessage> platformInboundMessageMapper) {
        this.eventProcessors = eventProcessors;
        this.platformInstructionSender = platformInstructionSender;
        this.platformInboundMessageMapper = platformInboundMessageMapper;
        this.lastProcessorsInfo = new HashMap<String, PlatformInboundInstruction>();
    }

    @Override
    public void notifyInformation() {
        block2: {
            try {
                this.eventProcessors.forEach(processor -> {
                    PlatformInboundInstruction instruction = this.platformInboundMessageMapper.apply((EventProcessor)processor).instruction();
                    if (!instruction.equals(this.lastProcessorsInfo.get(processor.getName()))) {
                        this.platformInstructionSender.accept(instruction);
                    }
                    this.lastProcessorsInfo.put(processor.getName(), instruction);
                });
                this.logError.set(true);
            }
            catch (OutOfDirectMemoryError | Exception e) {
                if (!this.logError.get()) break block2;
                logger.warn("Sending processor status failed: {}", (Object)e.getMessage());
                this.logError.set(false);
            }
        }
    }
}

