/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import io.axoniq.axonserver.grpc.ErrorMessage;
import io.grpc.stub.StreamObserver;
import org.axonframework.axonserver.connector.ErrorCode;

@FunctionalInterface
public interface InstructionAckSource<T> {
    default public void sendSuccessfulAck(String instructionId, StreamObserver<T> stream) {
        this.sendAck(instructionId, true, null, stream);
    }

    default public void sendUnsupportedInstruction(String instructionId, String source, StreamObserver<T> stream) {
        ErrorMessage unsupportedInstruction = ErrorMessage.newBuilder().setErrorCode(ErrorCode.UNSUPPORTED_INSTRUCTION.errorCode()).setLocation(source).addDetails("Unsupported instruction").build();
        this.sendUnsuccessfulAck(instructionId, unsupportedInstruction, stream);
    }

    default public void sendUnsuccessfulAck(String instructionId, ErrorMessage error, StreamObserver<T> stream) {
        this.sendAck(instructionId, false, error, stream);
    }

    public void sendAck(String var1, boolean var2, ErrorMessage var3, StreamObserver<T> var4);
}

