/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.queryhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.OptionalInt;
import org.axonframework.common.ObjectUtils;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.core.GenericMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageDecorator;
import org.axonframework.messaging.core.MessageType;
import org.axonframework.messaging.core.Metadata;
import org.axonframework.messaging.queryhandling.QueryMessage;

public class GenericQueryMessage
extends MessageDecorator
implements QueryMessage {
    private final Integer priority;

    public GenericQueryMessage(@Nonnull MessageType type, @Nullable Object payload) {
        this(new GenericMessage(type, payload, Metadata.emptyInstance()), null);
    }

    public GenericQueryMessage(@Nonnull Message delegate) {
        this(delegate, null);
    }

    public GenericQueryMessage(@Nonnull Message delegate, @Nullable Integer priority) {
        super(delegate);
        this.priority = priority;
    }

    @Override
    @Nonnull
    public QueryMessage withMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericQueryMessage(this.delegate().withMetadata(metadata), this.priority);
    }

    @Override
    @Nonnull
    public QueryMessage andMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericQueryMessage(this.delegate().andMetadata(metadata), this.priority);
    }

    @Override
    @Nonnull
    public QueryMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        if (ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType())) {
            return this;
        }
        Message delegate = this.delegate();
        GenericMessage converted = new GenericMessage(delegate.identifier(), delegate.type(), convertedPayload, (Map<String, String>)delegate.metadata());
        return new GenericQueryMessage(converted, this.priority);
    }

    @Override
    public OptionalInt priority() {
        return this.priority != null ? OptionalInt.of(this.priority) : OptionalInt.empty();
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append(", priority='").append(this.priority().orElse(0)).append("'");
    }

    @Override
    protected String describeType() {
        return "GenericQueryMessage";
    }
}

