/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.sequencing;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.sequencing.SequencingPolicy;

public class FallbackSequencingPolicy<E extends Exception>
implements SequencingPolicy {
    private final SequencingPolicy delegate;
    private final SequencingPolicy fallback;
    private final Class<E> exceptionType;

    public FallbackSequencingPolicy(@Nonnull SequencingPolicy delegate, @Nonnull SequencingPolicy fallback, @Nonnull Class<E> exceptionType) {
        this.delegate = Objects.requireNonNull(delegate, "Delegate may not be null.");
        this.fallback = Objects.requireNonNull(fallback, "Fallback may not be null.");
        this.exceptionType = Objects.requireNonNull(exceptionType, "Exception type may not be null.");
    }

    @Override
    public Optional<Object> getSequenceIdentifierFor(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        try {
            return this.delegate.getSequenceIdentifierFor(event, context);
        }
        catch (Exception e) {
            if (this.exceptionType.isInstance(e)) {
                return this.fallback.getSequenceIdentifierFor(event, context);
            }
            throw e;
        }
    }
}

