/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.gateway;

import jakarta.annotation.Nonnull;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.Metadata;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.GenericEventMessage;

class EventPublishingUtils {
    private EventPublishingUtils() {
    }

    static EventMessage asEventMessage(@Nonnull Object event, MessageTypeResolver messageTypeResolver) {
        if (event instanceof EventMessage) {
            EventMessage e = (EventMessage)event;
            return e;
        }
        if (event instanceof Message) {
            Message message = (Message)event;
            return new GenericEventMessage(message, () -> GenericEventMessage.clock.instant());
        }
        return new GenericEventMessage(messageTypeResolver.resolveOrThrow(event), event, Metadata.emptyInstance());
    }
}

