/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.gateway;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.EventSink;
import org.axonframework.messaging.eventhandling.gateway.EventGateway;
import org.axonframework.messaging.eventhandling.gateway.EventPublishingUtils;

public class DefaultEventGateway
implements EventGateway {
    private final EventSink eventSink;
    private final MessageTypeResolver messageTypeResolver;

    public DefaultEventGateway(@Nonnull EventSink eventSink, @Nonnull MessageTypeResolver messageTypeResolver) {
        this.eventSink = Objects.requireNonNull(eventSink, "EventSink may not be null");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "MessageTypeResolver may not be null");
    }

    @Override
    public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<?> events) {
        List<EventMessage> eventMessages = events.stream().map(event -> EventPublishingUtils.asEventMessage(event, this.messageTypeResolver)).collect(Collectors.toList());
        return this.eventSink.publish(context, eventMessages);
    }
}

