/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.Module;
import org.axonframework.messaging.eventhandling.configuration.EventHandlingComponentsConfigurer;
import org.axonframework.messaging.eventhandling.configuration.EventProcessorConfiguration;
import org.axonframework.messaging.eventhandling.processing.streaming.pooled.PooledStreamingEventProcessorConfiguration;
import org.axonframework.messaging.eventhandling.processing.streaming.pooled.PooledStreamingEventProcessorModule;
import org.axonframework.messaging.eventhandling.processing.subscribing.SubscribingEventProcessorConfiguration;
import org.axonframework.messaging.eventhandling.processing.subscribing.SubscribingEventProcessorModule;

public interface EventProcessorModule
extends Module {
    public static EventHandlingPhase<SubscribingEventProcessorModule, SubscribingEventProcessorConfiguration> subscribing(@Nonnull String processorName) {
        return new SubscribingEventProcessorModule(processorName);
    }

    public static EventHandlingPhase<PooledStreamingEventProcessorModule, PooledStreamingEventProcessorConfiguration> pooledStreaming(@Nonnull String processorName) {
        return new PooledStreamingEventProcessorModule(processorName);
    }

    public static interface CustomizationPhase<P extends EventProcessorModule, C extends EventProcessorConfiguration> {
        public P customized(@Nonnull BiFunction<Configuration, C, C> var1);

        default public P notCustomized() {
            return this.customized((cfg, processorConfig) -> processorConfig);
        }
    }

    public static interface EventHandlingPhase<P extends EventProcessorModule, C extends EventProcessorConfiguration> {
        public CustomizationPhase<P, C> eventHandlingComponents(@Nonnull Function<EventHandlingComponentsConfigurer.RequiredComponentPhase, EventHandlingComponentsConfigurer.CompletePhase> var1);
    }
}

