/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.eventhandling.EventHandlingComponent;
import org.axonframework.messaging.eventhandling.annotation.AnnotatedEventHandlingComponent;

public interface EventHandlingComponentsConfigurer {

    public static interface CompletePhase {
        @Nonnull
        public CompletePhase decorated(@Nonnull BiFunction<Configuration, EventHandlingComponent, EventHandlingComponent> var1);

        @Nonnull
        public List<ComponentBuilder<EventHandlingComponent>> toList();

        @Nonnull
        default public List<EventHandlingComponent> build(Configuration configuration) {
            return this.toList().stream().map(builder -> (EventHandlingComponent)builder.build(configuration)).toList();
        }
    }

    public static interface ComponentsPhase<T> {
        @Nonnull
        public AdditionalComponentPhase declarative(@Nonnull ComponentBuilder<EventHandlingComponent> var1);

        @Nonnull
        default public AdditionalComponentPhase annotated(@Nonnull ComponentBuilder<Object> handlingComponentBuilder) {
            Objects.requireNonNull(handlingComponentBuilder, "The handling component builder cannot be null.");
            return this.declarative(c -> new AnnotatedEventHandlingComponent(handlingComponentBuilder.build(c), c.getComponent(ParameterResolverFactory.class)));
        }
    }

    public static interface AdditionalComponentPhase
    extends ComponentsPhase<AdditionalComponentPhase>,
    CompletePhase {
    }

    public static interface RequiredComponentPhase
    extends ComponentsPhase<AdditionalComponentPhase> {
    }
}

