/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.interception;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.common.TypeReference;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.Component;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.LazyInitializedComponentDefinition;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.interception.HandlerInterceptorRegistry;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.queryhandling.QueryMessage;

@Internal
public class DefaultHandlerInterceptorRegistry
implements HandlerInterceptorRegistry {
    private static final TypeReference<MessageHandlerInterceptor<Message>> MESSAGE_INTERCEPTOR_TYPE_REF = new TypeReference<MessageHandlerInterceptor<Message>>(){};
    private static final TypeReference<MessageHandlerInterceptor<? super CommandMessage>> COMMAND_INTERCEPTOR_TYPE_REF = new TypeReference<MessageHandlerInterceptor<? super CommandMessage>>(){};
    private static final TypeReference<MessageHandlerInterceptor<? super EventMessage>> EVENT_INTERCEPTOR_TYPE_REF = new TypeReference<MessageHandlerInterceptor<? super EventMessage>>(){};
    private static final TypeReference<MessageHandlerInterceptor<? super QueryMessage>> QUERY_INTERCEPTOR_TYPE_REF = new TypeReference<MessageHandlerInterceptor<? super QueryMessage>>(){};
    private final List<ComponentDefinition<MessageHandlerInterceptor<? super CommandMessage>>> commandInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageHandlerInterceptor<? super CommandMessage>>>();
    private final List<ComponentDefinition<MessageHandlerInterceptor<? super EventMessage>>> eventInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageHandlerInterceptor<? super EventMessage>>>();
    private final List<ComponentDefinition<MessageHandlerInterceptor<? super QueryMessage>>> queryInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageHandlerInterceptor<? super QueryMessage>>>();

    @Override
    @Nonnull
    public HandlerInterceptorRegistry registerInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<Message>> interceptorBuilder) {
        GenericInterceptorDefinition genericInterceptorDef = new GenericInterceptorDefinition(interceptorBuilder);
        this.registerCommandInterceptor(config -> {
            MessageHandlerInterceptor genericInterceptor = (MessageHandlerInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnHandle(message, context, (m, c) -> chain.proceed((CommandMessage)m, c));
        });
        this.registerEventInterceptor(config -> {
            MessageHandlerInterceptor genericInterceptor = (MessageHandlerInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnHandle(message, context, (m, c) -> chain.proceed((EventMessage)m, c));
        });
        this.registerQueryInterceptor(config -> {
            MessageHandlerInterceptor genericInterceptor = (MessageHandlerInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnHandle(message, context, (m, c) -> chain.proceed((QueryMessage)m, c));
        });
        return this;
    }

    @Override
    @Nonnull
    public HandlerInterceptorRegistry registerCommandInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super CommandMessage>> interceptorBuilder) {
        this.commandInterceptorDefinitions.add(ComponentDefinition.ofType(COMMAND_INTERCEPTOR_TYPE_REF).withBuilder(c -> (MessageHandlerInterceptor)interceptorBuilder.build(c)));
        return this;
    }

    @Override
    @Nonnull
    public HandlerInterceptorRegistry registerEventInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super EventMessage>> interceptorBuilder) {
        this.eventInterceptorDefinitions.add(ComponentDefinition.ofType(EVENT_INTERCEPTOR_TYPE_REF).withBuilder(c -> (MessageHandlerInterceptor)interceptorBuilder.build(c)));
        return this;
    }

    @Override
    @Nonnull
    public HandlerInterceptorRegistry registerQueryInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super QueryMessage>> interceptorBuilder) {
        this.queryInterceptorDefinitions.add(ComponentDefinition.ofType(QUERY_INTERCEPTOR_TYPE_REF).withBuilder(c -> (MessageHandlerInterceptor)interceptorBuilder.build(c)));
        return this;
    }

    @Override
    @Nonnull
    public List<MessageHandlerInterceptor<? super CommandMessage>> commandInterceptors(@Nonnull Configuration config) {
        return DefaultHandlerInterceptorRegistry.resolveInterceptors(this.commandInterceptorDefinitions, config);
    }

    @Override
    @Nonnull
    public List<MessageHandlerInterceptor<? super EventMessage>> eventInterceptors(@Nonnull Configuration config) {
        return DefaultHandlerInterceptorRegistry.resolveInterceptors(this.eventInterceptorDefinitions, config);
    }

    @Override
    @Nonnull
    public List<MessageHandlerInterceptor<? super QueryMessage>> queryInterceptors(@Nonnull Configuration config) {
        return DefaultHandlerInterceptorRegistry.resolveInterceptors(this.queryInterceptorDefinitions, config);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("commandHandlerInterceptors", this.commandInterceptorDefinitions);
        descriptor.describeProperty("eventHandlerInterceptors", this.eventInterceptorDefinitions);
        descriptor.describeProperty("queryHandlerInterceptors", this.queryInterceptorDefinitions);
    }

    private static <T extends Message> List<MessageHandlerInterceptor<? super T>> resolveInterceptors(List<ComponentDefinition<MessageHandlerInterceptor<? super T>>> definitions, Configuration config) {
        ArrayList<MessageHandlerInterceptor<T>> handlerInterceptors = new ArrayList<MessageHandlerInterceptor<T>>();
        for (ComponentDefinition<MessageHandlerInterceptor<T>> componentDefinition : definitions) {
            if (!(componentDefinition instanceof ComponentDefinition.ComponentCreator)) {
                throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(componentDefinition));
            }
            ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)componentDefinition;
            MessageHandlerInterceptor handlerInterceptor = (MessageHandlerInterceptor)creator.createComponent().resolve(config);
            handlerInterceptors.add(handlerInterceptor);
        }
        return handlerInterceptors;
    }

    private static class GenericInterceptorDefinition
    extends LazyInitializedComponentDefinition<MessageHandlerInterceptor<Message>, MessageHandlerInterceptor<Message>> {
        public GenericInterceptorDefinition(ComponentBuilder<MessageHandlerInterceptor<Message>> builder) {
            super(new Component.Identifier<MessageHandlerInterceptor<Message>>(MESSAGE_INTERCEPTOR_TYPE_REF, null), builder);
        }
    }
}

