/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.util.ClasspathResolver;
import org.axonframework.messaging.core.FluxUtils;
import org.axonframework.messaging.core.GenericMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.MonoUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
public class MessageStreamResolverUtils {
    public static MessageStream<?> resolveToStream(@Nullable Object result, @Nonnull MessageTypeResolver typeResolver) {
        MessageStream<Message> messageStream;
        Objects.requireNonNull(typeResolver, "The Message Type Resolver must not be null.");
        if (result == null) {
            return MessageStream.empty();
        }
        if (ClasspathResolver.projectReactorOnClasspath()) {
            if (result instanceof Mono) {
                Mono mono = (Mono)result;
                return MonoUtils.asSingle(mono.map(r -> new GenericMessage(typeResolver.resolveOrThrow(r), r)));
            }
            if (result instanceof Flux) {
                Flux flux = (Flux)result;
                return FluxUtils.asMessageStream(flux.map(r -> new GenericMessage(typeResolver.resolveOrThrow(r), r)));
            }
        }
        Object object = result;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MessageStream.class, CompletableFuture.class, Optional.class, Optional.class, Iterable.class, Stream.class}, (Object)object2, n)) {
                case 0: {
                    MessageStream.Empty<Message> messageStream2;
                    messageStream = messageStream2 = (MessageStream.Empty<Message>)object2;
                    break block8;
                }
                case 1: {
                    CompletableFuture future = (CompletableFuture)object2;
                    messageStream = MessageStream.fromFuture(future.thenApply(r -> new GenericMessage(typeResolver.resolveOrThrow(r), r)));
                    break block8;
                }
                case 2: {
                    Optional optional = (Optional)object2;
                    if (!optional.isPresent()) {
                        n = 3;
                        continue block8;
                    }
                    Object r2 = optional.get();
                    messageStream = MessageStream.just(new GenericMessage(typeResolver.resolveOrThrow(r2), r2));
                    break block8;
                }
                case 3: {
                    Optional empty = (Optional)object2;
                    messageStream = MessageStream.empty();
                    break block8;
                }
                case 4: {
                    Iterable iterable = (Iterable)object2;
                    messageStream = MessageStream.fromStream(StreamSupport.stream(iterable.spliterator(), false).map(r -> new GenericMessage(typeResolver.resolveOrThrow(r), r)));
                    break block8;
                }
                case 5: {
                    Stream stream = (Stream)object2;
                    messageStream = MessageStream.fromStream(stream.map(r -> new GenericMessage(typeResolver.resolveOrThrow(r), r)));
                    break block8;
                }
                default: {
                    messageStream = MessageStream.just(new GenericMessage(typeResolver.resolveOrThrow(result), result));
                    break block8;
                }
            }
            break;
        }
        return messageStream;
    }

    private MessageStreamResolverUtils() {
    }
}

