/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.Priority;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.Metadata;
import org.axonframework.messaging.core.annotation.MessageHandler;
import org.axonframework.messaging.core.annotation.MetadataValue;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.annotation.PayloadParameterResolver;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

@Priority(value=-1073741824)
public class DefaultParameterResolverFactory
implements ParameterResolverFactory {
    @Nullable
    public ParameterResolver createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        Class<Object> payloadType;
        Class<?> parameterType = parameters[parameterIndex].getType();
        if (Message.class.isAssignableFrom(parameterType)) {
            return new MessageParameterResolver(parameterType);
        }
        Optional<Map<String, Object>> metadataValueAnnotation = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)parameters[parameterIndex], MetadataValue.class);
        if (metadataValueAnnotation.isPresent()) {
            return new AnnotatedMetadataParameterResolver(metadataValueAnnotation.get(), parameterType);
        }
        if (Metadata.class.isAssignableFrom(parameterType)) {
            return MetadataParameterResolver.INSTANCE;
        }
        if (parameterIndex == 0 && (payloadType = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)executable, MessageHandler.class).map(attr -> attr.get("payloadType")).orElse(Object.class)).isAssignableFrom(parameterType)) {
            return new PayloadParameterResolver(parameterType);
        }
        return null;
    }

    private static class MessageParameterResolver
    implements ParameterResolver<Message> {
        private final Class<?> parameterType;

        public MessageParameterResolver(Class<?> parameterType) {
            this.parameterType = parameterType;
        }

        @Override
        @Nonnull
        public CompletableFuture<Message> resolveParameterValue(@Nonnull ProcessingContext context) {
            return CompletableFuture.completedFuture(Message.fromContext(context));
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            Message message = Message.fromContext(context);
            if (message == null) {
                return false;
            }
            return this.parameterType.isAssignableFrom(message.getClass());
        }
    }

    private static class AnnotatedMetadataParameterResolver
    implements ParameterResolver<Object> {
        private static final String REQUIRED_PROPERTY = "required";
        private static final String METADATA_VALUE_PROPERTY = "metadataValue";
        private final Map<String, Object> metadataValue;
        private final Class<?> parameterType;

        public AnnotatedMetadataParameterResolver(Map<String, Object> metadataValue, Class<?> parameterType) {
            this.metadataValue = metadataValue;
            this.parameterType = parameterType;
        }

        @Override
        @Nonnull
        public CompletableFuture<Object> resolveParameterValue(@Nonnull ProcessingContext context) {
            return CompletableFuture.completedFuture(Message.fromContext(context).metadata().get(this.metadataValue.get(METADATA_VALUE_PROPERTY).toString()));
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            Message message = Message.fromContext(context);
            if (message == null) {
                return false;
            }
            return !this.parameterType.isPrimitive() && (Boolean)this.metadataValue.get(REQUIRED_PROPERTY) == false || message.metadata().containsKey(this.metadataValue.get(METADATA_VALUE_PROPERTY).toString()) && this.parameterType.isInstance(message.metadata().get(this.metadataValue.get(METADATA_VALUE_PROPERTY).toString()));
        }
    }

    private static final class MetadataParameterResolver
    implements ParameterResolver<Metadata> {
        private static final MetadataParameterResolver INSTANCE = new MetadataParameterResolver();

        private MetadataParameterResolver() {
        }

        @Override
        @Nonnull
        public CompletableFuture<Metadata> resolveParameterValue(@Nonnull ProcessingContext context) {
            Message message = Message.fromContext(context);
            return CompletableFuture.completedFuture(message.metadata());
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) != null;
        }
    }
}

