/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.commandhandling.annotation;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.commandhandling.CommandHandlingComponent;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.CommandResultMessage;
import org.axonframework.messaging.commandhandling.GenericCommandResultMessage;
import org.axonframework.messaging.commandhandling.SimpleCommandHandlingComponent;
import org.axonframework.messaging.commandhandling.annotation.CommandHandlingMember;
import org.axonframework.messaging.core.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.MessageType;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.core.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.core.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.core.annotation.HandlerDefinition;
import org.axonframework.messaging.core.annotation.MessageHandlingMember;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.conversion.MessageConverter;
import org.axonframework.messaging.core.interception.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

public class AnnotatedCommandHandlingComponent<T>
implements CommandHandlingComponent {
    private final SimpleCommandHandlingComponent handlingComponent;
    private final T target;
    private final AnnotatedHandlerInspector<T> model;
    private final MessageTypeResolver messageTypeResolver;
    private final MessageConverter converter;

    public AnnotatedCommandHandlingComponent(@Nonnull T annotatedCommandHandler, @Nonnull MessageConverter converter) {
        this(annotatedCommandHandler, ClasspathParameterResolverFactory.forClass(annotatedCommandHandler.getClass()), converter);
    }

    public AnnotatedCommandHandlingComponent(@Nonnull T annotatedCommandHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull MessageConverter converter) {
        this(annotatedCommandHandler, parameterResolverFactory, ClasspathHandlerDefinition.forClass(annotatedCommandHandler.getClass()), new ClassBasedMessageTypeResolver(), converter);
    }

    public AnnotatedCommandHandlingComponent(@Nonnull T annotatedCommandHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull HandlerDefinition handlerDefinition, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull MessageConverter converter) {
        this.handlingComponent = SimpleCommandHandlingComponent.create("AnnotatedCommandHandlingComponent[%s]".formatted(annotatedCommandHandler.getClass().getName()));
        this.target = Objects.requireNonNull(annotatedCommandHandler, "The Annotated Command Handler may not be null.");
        this.model = AnnotatedHandlerInspector.inspectType(annotatedCommandHandler.getClass(), parameterResolverFactory, handlerDefinition);
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The MessageTypeResolver may not be null.");
        this.converter = Objects.requireNonNull(converter, "The Converter may not be null.");
        this.initializeHandlersBasedOnModel();
    }

    private void initializeHandlersBasedOnModel() {
        this.model.getAllHandlers().forEach((modelClass, handlers) -> handlers.stream().filter(h -> h.canHandleMessageType(CommandMessage.class)).forEach(this::registerHandler));
    }

    private void registerHandler(MessageHandlingMember<? super T> handler) {
        Class<?> payloadType = handler.payloadType();
        QualifiedName qualifiedName = handler.unwrap(CommandHandlingMember.class).map(CommandHandlingMember::commandName).filter(name -> !name.equals(payloadType.getName())).map(QualifiedName::new).orElseGet(() -> this.messageTypeResolver.resolve(payloadType).orElse(new MessageType(payloadType)).qualifiedName());
        MessageHandlerInterceptorMemberChain<T> interceptorChain = this.model.chainedInterceptor(this.target.getClass());
        this.handlingComponent.subscribe(qualifiedName, (command, ctx) -> interceptorChain.handle(command.withConvertedPayload((Class)payloadType, (Converter)this.converter), ctx, this.target, handler).mapMessage(this::asCommandResultMessage).first().cast());
    }

    private CommandResultMessage asCommandResultMessage(@Nonnull Message commandResult) {
        return commandResult instanceof CommandResultMessage ? (CommandResultMessage)commandResult : new GenericCommandResultMessage(commandResult);
    }

    @Override
    @Nonnull
    public MessageStream.Single<CommandResultMessage> handle(@Nonnull CommandMessage command, @Nonnull ProcessingContext processingContext) {
        return this.handlingComponent.handle(command, processingContext);
    }

    @Override
    public Set<QualifiedName> supportedCommands() {
        return Set.copyOf(this.handlingComponent.supportedCommands());
    }
}

