/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.commandhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.axonframework.common.ObjectUtils;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.core.GenericMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageDecorator;
import org.axonframework.messaging.core.MessageType;
import org.axonframework.messaging.core.Metadata;

public class GenericCommandMessage
extends MessageDecorator
implements CommandMessage {
    private final String routingKey;
    private final Integer priority;

    public GenericCommandMessage(@Nonnull MessageType type, @Nullable Object payload) {
        this(type, payload, Metadata.emptyInstance());
    }

    public GenericCommandMessage(@Nonnull MessageType type, @Nullable Object payload, @Nonnull Map<String, String> metadata) {
        this(new GenericMessage(type, payload, metadata));
    }

    public GenericCommandMessage(@Nonnull MessageType type, @Nonnull Object payload, @Nonnull Map<String, String> metadata, @Nullable String routingKey, @Nullable Integer priority) {
        this(new GenericMessage(type, payload, metadata), routingKey, priority);
    }

    public GenericCommandMessage(@Nonnull Message delegate) {
        this(delegate, null, null);
    }

    public GenericCommandMessage(@Nonnull Message delegate, @Nullable String routingKey, @Nullable Integer priority) {
        super(delegate);
        this.routingKey = routingKey;
        this.priority = priority;
    }

    @Override
    public Optional<String> routingKey() {
        return Optional.ofNullable(this.routingKey);
    }

    @Override
    public OptionalInt priority() {
        return this.priority != null ? OptionalInt.of(this.priority) : OptionalInt.empty();
    }

    @Override
    @Nonnull
    public CommandMessage withMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericCommandMessage(this.delegate().withMetadata(metadata));
    }

    @Override
    @Nonnull
    public CommandMessage andMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericCommandMessage(this.delegate().andMetadata(metadata));
    }

    @Override
    @Nonnull
    public CommandMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        if (ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType())) {
            return this;
        }
        Message delegate = this.delegate();
        GenericMessage converted = new GenericMessage(delegate.identifier(), delegate.type(), convertedPayload, (Map<String, String>)delegate.metadata());
        return new GenericCommandMessage(converted, this.routingKey, this.priority);
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append(", routingKey='").append(this.routingKey().orElse("null")).append("', priority='").append(this.priority().orElse(0)).append("'");
    }

    @Override
    protected String describeType() {
        return "GenericCommandMessage";
    }
}

