/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.configuration;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.AbstractComponent;
import org.axonframework.common.configuration.Component;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.infra.ComponentDescriptor;

@Internal
public class InstantiatedComponentDefinition<C>
extends AbstractComponent<C, C> {
    private final C instance;

    public InstantiatedComponentDefinition(@Nonnull Component.Identifier<C> identifier, @Nonnull C instance) {
        super(identifier, Collections.emptyList(), Collections.emptyList());
        this.instance = Objects.requireNonNull(instance, "The instance must not be null.");
    }

    @Override
    public C doResolve(@Nonnull Configuration configuration) {
        return this.instance;
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        super.describeTo(descriptor);
        descriptor.describeProperty("instance", this.instance);
    }
}

