/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.axonframework.common.ExceptionUtils;

public class RemoteExceptionDescription {
    private static final String DELIMITER = ": ";
    private static final String CAUSED_BY = "\nCaused by ";
    private final List<String> descriptions;
    private final boolean persistent;

    public static RemoteExceptionDescription describing(Throwable exception) {
        boolean isPersistent = ExceptionUtils.isExplicitlyNonTransient(exception);
        return new RemoteExceptionDescription(RemoteExceptionDescription.createDescription(exception, new ArrayList<String>()), isPersistent);
    }

    private static List<String> createDescription(Throwable exception, List<String> descriptions) {
        descriptions.add(exception.getClass().getName() + DELIMITER + exception.getMessage());
        Throwable cause = exception.getCause();
        return cause != null ? RemoteExceptionDescription.createDescription(cause, descriptions) : descriptions;
    }

    public RemoteExceptionDescription(@JsonProperty(value="descriptions") List<String> descriptions) {
        this(descriptions, false);
    }

    @JsonCreator
    @ConstructorProperties(value={"descriptions, persistent"})
    public RemoteExceptionDescription(@JsonProperty(value="descriptions") List<String> descriptions, @JsonProperty(value="persistent") boolean persistent) {
        this.persistent = persistent;
        this.descriptions = new ArrayList<String>(descriptions);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public List<String> getDescriptions() {
        return this.descriptions;
    }

    public int hashCode() {
        return Objects.hash(this.descriptions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteExceptionDescription other = (RemoteExceptionDescription)obj;
        return Objects.equals(this.descriptions, other.descriptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.descriptions.size(); ++i) {
            if (i != 0) {
                sb.append(CAUSED_BY);
            }
            sb.append(this.descriptions.get(i));
        }
        return sb.toString();
    }
}

