/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.dbscheduler;

import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerState;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import com.github.kagkarlsson.scheduler.task.TaskWithDataDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.eventhandling.scheduling.SchedulingException;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerBinaryEventData;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerHumanReadableEventData;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerScheduleToken;
import org.axonframework.eventhandling.scheduling.dbscheduler.EventSchedulerNotSuppliedException;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.LegacyDefaultUnitOfWork;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSchedulerEventScheduler
implements EventScheduler {
    private static final Logger logger = LoggerFactory.getLogger(DbSchedulerEventScheduler.class);
    private static final TaskWithDataDescriptor<DbSchedulerHumanReadableEventData> humanReadableTaskDescriptor = new TaskWithDataDescriptor("AxonScheduledEvent", DbSchedulerHumanReadableEventData.class);
    private static final TaskWithDataDescriptor<DbSchedulerBinaryEventData> binaryTaskDescriptor = new TaskWithDataDescriptor("AxonScheduledEvent", DbSchedulerBinaryEventData.class);
    private final Scheduler scheduler;
    private final Serializer serializer;
    private final TransactionManager transactionManager;
    private final EventBus eventBus;
    private final boolean useBinaryPojo;
    private final boolean startScheduler;
    private final boolean stopScheduler;
    private final MessageTypeResolver messageTypeResolver;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    protected DbSchedulerEventScheduler(Builder builder) {
        builder.validate();
        this.scheduler = builder.scheduler;
        this.serializer = builder.serializer;
        this.transactionManager = builder.transactionManager;
        this.eventBus = builder.eventBus;
        this.useBinaryPojo = builder.useBinaryPojo;
        this.startScheduler = builder.startScheduler;
        this.stopScheduler = builder.stopScheduler;
        this.messageTypeResolver = builder.messageTypeResolver;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ScheduleToken schedule(Instant triggerDateTime, Object event) {
        String identifier = IdentifierFactory.getInstance().generateIdentifier();
        DbSchedulerScheduleToken taskInstanceId = new DbSchedulerScheduleToken(identifier);
        try {
            TaskInstance<?> taskInstance = this.useBinaryPojo ? this.getBinaryTask(taskInstanceId, event) : this.getHumanReadableTask(taskInstanceId, event);
            this.scheduler.schedule(taskInstance, triggerDateTime);
        }
        catch (Exception e) {
            throw new SchedulingException("An error occurred while scheduling an event.", e);
        }
        return taskInstanceId;
    }

    public static Task<DbSchedulerHumanReadableEventData> humanReadableTask(Supplier<DbSchedulerEventScheduler> eventSchedulerSupplier) {
        return new Tasks.OneTimeTaskBuilder("AxonScheduledEvent", DbSchedulerHumanReadableEventData.class).execute((ti, context) -> {
            DbSchedulerEventScheduler eventScheduler = (DbSchedulerEventScheduler)eventSchedulerSupplier.get();
            if (Objects.isNull(eventScheduler)) {
                throw new EventSchedulerNotSuppliedException();
            }
            EventMessage<?> eventMessage = eventScheduler.fromDbSchedulerEventData((DbSchedulerHumanReadableEventData)ti.getData());
            eventScheduler.publishEventMessage(eventMessage);
        });
    }

    public static Task<DbSchedulerBinaryEventData> binaryTask(Supplier<DbSchedulerEventScheduler> eventSchedulerSupplier) {
        return new Tasks.OneTimeTaskBuilder("AxonScheduledEvent", DbSchedulerBinaryEventData.class).execute((ti, context) -> {
            DbSchedulerEventScheduler eventScheduler = (DbSchedulerEventScheduler)eventSchedulerSupplier.get();
            if (Objects.isNull(eventScheduler)) {
                throw new EventSchedulerNotSuppliedException();
            }
            EventMessage<?> eventMessage = eventScheduler.fromDbSchedulerEventData((DbSchedulerBinaryEventData)ti.getData());
            eventScheduler.publishEventMessage(eventMessage);
        });
    }

    private TaskInstance<?> getBinaryTask(DbSchedulerScheduleToken taskInstanceId, Object event) {
        DbSchedulerBinaryEventData data = event instanceof EventMessage ? this.binaryDataFromEvent((EventMessage)event) : this.binaryDataFromObject(event);
        return binaryTaskDescriptor.instance(taskInstanceId.getId(), (Object)data);
    }

    private DbSchedulerBinaryEventData binaryDataFromObject(Object event) {
        SerializedObject<byte[]> serialized = this.serializer.serialize(event, byte[].class);
        byte[] serializedPayload = serialized.getData();
        String payloadClass = serialized.getType().getName();
        String revision = serialized.getType().getRevision();
        return new DbSchedulerBinaryEventData(serializedPayload, payloadClass, revision, null);
    }

    private DbSchedulerBinaryEventData binaryDataFromEvent(EventMessage<?> eventMessage) {
        SerializedObject<byte[]> serialized = this.serializer.serialize(eventMessage.getPayload(), byte[].class);
        byte[] serializedPayload = serialized.getData();
        String payloadClass = serialized.getType().getName();
        String revision = serialized.getType().getRevision();
        byte[] serializedMetadata = this.serializer.serialize(eventMessage.getMetaData(), byte[].class).getData();
        return new DbSchedulerBinaryEventData(serializedPayload, payloadClass, revision, serializedMetadata);
    }

    private TaskInstance<?> getHumanReadableTask(DbSchedulerScheduleToken taskInstanceId, Object event) {
        DbSchedulerHumanReadableEventData data = event instanceof EventMessage ? this.humanReadableDataFromEvent((EventMessage)event) : this.humanReadableDataFromObject(event);
        return humanReadableTaskDescriptor.instance(taskInstanceId.getId(), (Object)data);
    }

    private DbSchedulerHumanReadableEventData humanReadableDataFromObject(Object event) {
        SerializedObject<String> serialized = this.serializer.serialize(event, String.class);
        String serializedPayload = serialized.getData();
        String payloadClass = serialized.getType().getName();
        String revision = serialized.getType().getRevision();
        return new DbSchedulerHumanReadableEventData(serializedPayload, payloadClass, revision, null);
    }

    private DbSchedulerHumanReadableEventData humanReadableDataFromEvent(EventMessage<?> eventMessage) {
        SerializedObject<String> serialized = this.serializer.serialize(eventMessage.getPayload(), String.class);
        String serializedPayload = serialized.getData();
        String payloadClass = serialized.getType().getName();
        String revision = serialized.getType().getRevision();
        String serializedMetadata = this.serializer.serialize(eventMessage.getMetaData(), String.class).getData();
        return new DbSchedulerHumanReadableEventData(serializedPayload, payloadClass, revision, serializedMetadata);
    }

    private EventMessage<?> fromDbSchedulerEventData(DbSchedulerBinaryEventData data) {
        SimpleSerializedObject<byte[]> serializedObject = new SimpleSerializedObject<byte[]>(data.getP(), byte[].class, data.getC(), data.getR());
        Object deserializedPayload = this.serializer.deserialize(serializedObject);
        Message<Object> eventMessage = this.asEventMessage(deserializedPayload);
        if (!Objects.isNull(data.getM())) {
            SimpleSerializedObject<byte[]> serializedMetaData = new SimpleSerializedObject<byte[]>(data.getM(), byte[].class, MetaData.class.getName(), null);
            eventMessage = eventMessage.andMetaData((Map)this.serializer.deserialize(serializedMetaData));
        }
        return eventMessage;
    }

    private <E> EventMessage<E> asEventMessage(@Nonnull Object event) {
        if (event instanceof EventMessage) {
            return (EventMessage)event;
        }
        if (event instanceof Message) {
            Message message = (Message)event;
            return new GenericEventMessage(message, () -> GenericEventMessage.clock.instant());
        }
        return new GenericEventMessage<Object>(this.messageTypeResolver.resolveOrThrow(event), event, MetaData.emptyInstance());
    }

    private EventMessage<?> fromDbSchedulerEventData(DbSchedulerHumanReadableEventData data) {
        SimpleSerializedObject<String> serializedObject = new SimpleSerializedObject<String>(data.getSerializedPayload(), String.class, data.getPayloadClass(), data.getRevision());
        Object deserializedPayload = this.serializer.deserialize(serializedObject);
        Message<Object> eventMessage = this.asEventMessage(deserializedPayload);
        if (!Objects.isNull(data.getSerializedMetadata())) {
            SimpleSerializedObject<String> serializedMetaData = new SimpleSerializedObject<String>(data.getSerializedMetadata(), String.class, MetaData.class.getName(), null);
            eventMessage = eventMessage.andMetaData((Map)this.serializer.deserialize(serializedMetaData));
        }
        return eventMessage;
    }

    @Override
    public ScheduleToken schedule(Duration triggerDuration, Object event) {
        return this.schedule(GenericEventMessage.clock.instant().plus(triggerDuration), event);
    }

    @Override
    public void cancelSchedule(ScheduleToken scheduleToken) {
        if (!(scheduleToken instanceof DbSchedulerScheduleToken)) {
            throw new IllegalArgumentException("The given ScheduleToken was not provided by this scheduler.");
        }
        DbSchedulerScheduleToken reference = (DbSchedulerScheduleToken)scheduleToken;
        this.scheduler.cancel((TaskInstanceId)reference);
    }

    public void start() {
        if (!this.startScheduler) {
            return;
        }
        SchedulerState state = this.scheduler.getSchedulerState();
        if (state.isShuttingDown()) {
            logger.warn("Scheduler is shutting down - will not attempting to start");
            return;
        }
        if (state.isStarted()) {
            logger.info("Scheduler already started - will not attempt to start again");
            return;
        }
        logger.info("Triggering scheduler start");
        this.scheduler.start();
    }

    @Override
    public void shutdown() {
        if (this.isShutdown.compareAndSet(false, true) && this.stopScheduler) {
            this.scheduler.stop();
        }
    }

    private void publishEventMessage(EventMessage eventMessage) {
        LegacyDefaultUnitOfWork<Object> unitOfWork = LegacyDefaultUnitOfWork.startAndGet(null);
        unitOfWork.attachTransaction(this.transactionManager);
        unitOfWork.execute(ctx -> this.eventBus.publish(eventMessage));
    }

    public static class Builder {
        private Scheduler scheduler;
        private Serializer serializer;
        private TransactionManager transactionManager = NoTransactionManager.INSTANCE;
        private EventBus eventBus;
        private boolean useBinaryPojo = true;
        private boolean startScheduler = true;
        private boolean stopScheduler = true;
        private MessageTypeResolver messageTypeResolver = new ClassBasedMessageTypeResolver();

        public Builder scheduler(Scheduler scheduler) {
            BuilderUtils.assertNonNull(scheduler, "Scheduler may not be null");
            this.scheduler = scheduler;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull(serializer, "Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder eventBus(EventBus eventBus) {
            BuilderUtils.assertNonNull(eventBus, "EventBus may not be null");
            this.eventBus = eventBus;
            return this;
        }

        public Builder useBinaryPojo(boolean useBinaryPojo) {
            this.useBinaryPojo = useBinaryPojo;
            return this;
        }

        public Builder startScheduler(boolean startScheduler) {
            this.startScheduler = startScheduler;
            return this;
        }

        public Builder stopScheduler(boolean stopScheduler) {
            this.stopScheduler = stopScheduler;
            return this;
        }

        public Builder messageNameResolver(MessageTypeResolver messageTypeResolver) {
            BuilderUtils.assertNonNull(messageTypeResolver, "MessageNameResolver may not be null");
            this.messageTypeResolver = messageTypeResolver;
            return this;
        }

        public DbSchedulerEventScheduler build() {
            return new DbSchedulerEventScheduler(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.scheduler, "The Scheduler is a hard requirement and should be provided.");
            BuilderUtils.assertNonNull(this.serializer, "The Serializer is a hard requirement and should be provided.");
            BuilderUtils.assertNonNull(this.eventBus, "The EventBus is a hard requirement and should be provided.");
        }
    }
}

