/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.common.Priority;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.SequenceNumber;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Priority(value=0x3FFFFFFF)
public final class SequenceNumberParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<SequenceNumber, Long> {
    private final ParameterResolver<Long> resolver = new SequenceNumberParameterResolver();

    public SequenceNumberParameterResolverFactory() {
        super(SequenceNumber.class, Long.class);
    }

    @Override
    protected ParameterResolver<Long> getResolver() {
        return this.resolver;
    }

    public static class SequenceNumberParameterResolver
    implements ParameterResolver<Long> {
        @Override
        @Nullable
        public Long resolveParameterValue(@Nonnull ProcessingContext context) {
            Message<?> message = Message.fromContext(context);
            if (message instanceof DomainEventMessage) {
                DomainEventMessage domainEventMessage = (DomainEventMessage)message;
                return domainEventMessage.getSequenceNumber();
            }
            return null;
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) instanceof DomainEventMessage;
        }
    }
}

