/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.dbscheduler;

import com.github.kagkarlsson.scheduler.ScheduledExecution;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerState;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import com.github.kagkarlsson.scheduler.task.TaskWithDataDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.deadline.AbstractDeadlineManager;
import org.axonframework.deadline.DeadlineException;
import org.axonframework.deadline.DeadlineManagerSpanFactory;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.DefaultDeadlineManagerSpanFactory;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.deadline.dbscheduler.DbSchedulerBinaryDeadlineDetails;
import org.axonframework.deadline.dbscheduler.DbSchedulerDeadlineToken;
import org.axonframework.deadline.dbscheduler.DbSchedulerHumanReadableDeadlineDetails;
import org.axonframework.deadline.dbscheduler.DeadlineManagerNotSuppliedException;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.ExecutionException;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.unitofwork.LegacyDefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSchedulerDeadlineManager
extends AbstractDeadlineManager {
    private static final Logger logger = LoggerFactory.getLogger(DbSchedulerDeadlineManager.class);
    private static final TaskWithDataDescriptor<DbSchedulerBinaryDeadlineDetails> binaryTaskDescriptor = new TaskWithDataDescriptor("AxonDeadline", DbSchedulerBinaryDeadlineDetails.class);
    private static final TaskWithDataDescriptor<DbSchedulerHumanReadableDeadlineDetails> humanReadableTaskDescriptor = new TaskWithDataDescriptor("AxonDeadline", DbSchedulerHumanReadableDeadlineDetails.class);
    private final ScopeAwareProvider scopeAwareProvider;
    private final Scheduler scheduler;
    private final Serializer serializer;
    private final TransactionManager transactionManager;
    private final DeadlineManagerSpanFactory spanFactory;
    private final boolean useBinaryPojo;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static Builder builder() {
        return new Builder();
    }

    protected DbSchedulerDeadlineManager(Builder builder) {
        builder.validate();
        this.scopeAwareProvider = builder.scopeAwareProvider;
        this.scheduler = builder.scheduler;
        this.serializer = builder.serializer;
        this.transactionManager = builder.transactionManager;
        this.spanFactory = builder.spanFactory;
        this.useBinaryPojo = builder.useBinaryPojo;
        this.messageTypeResolver = builder.messageTypeResolver;
    }

    @Override
    public String schedule(@Nonnull Instant triggerDateTime, @Nonnull String deadlineName, @Nullable Object messageOrPayload, @Nonnull ScopeDescriptor deadlineScope) {
        DeadlineMessage deadlineMessage = this.asDeadlineMessage(deadlineName, messageOrPayload, triggerDateTime);
        String identifier = IdentifierFactory.getInstance().generateIdentifier();
        DbSchedulerDeadlineToken taskInstanceId = new DbSchedulerDeadlineToken(identifier);
        Span span = this.spanFactory.createScheduleSpan(deadlineName, identifier, deadlineMessage);
        this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> {
            DeadlineMessage<Object> message = this.processDispatchInterceptors(deadlineMessage);
            TaskInstance<?> taskInstance = this.useBinaryPojo ? this.binaryTask(deadlineName, deadlineScope, message, taskInstanceId) : this.humanReadableTask(deadlineName, deadlineScope, message, taskInstanceId);
            this.scheduler.schedule(taskInstance, triggerDateTime);
            logger.debug("Task with id: [{}] was successfully created.", (Object)identifier);
        }));
        return identifier;
    }

    private TaskInstance<?> binaryTask(String deadlineName, ScopeDescriptor deadlineScope, DeadlineMessage<Object> interceptedDeadlineMessage, DbSchedulerDeadlineToken taskInstanceId) {
        DbSchedulerBinaryDeadlineDetails details = DbSchedulerBinaryDeadlineDetails.serialized(deadlineName, deadlineScope, interceptedDeadlineMessage, this.serializer);
        return binaryTaskDescriptor.instance(taskInstanceId.getId(), (Object)details);
    }

    private TaskInstance<?> humanReadableTask(String deadlineName, ScopeDescriptor deadlineScope, DeadlineMessage<Object> interceptedDeadlineMessage, DbSchedulerDeadlineToken taskInstanceId) {
        DbSchedulerHumanReadableDeadlineDetails details = DbSchedulerHumanReadableDeadlineDetails.serialized(deadlineName, deadlineScope, interceptedDeadlineMessage, this.serializer);
        return humanReadableTaskDescriptor.instance(taskInstanceId.getId(), (Object)details);
    }

    public static Task<DbSchedulerBinaryDeadlineDetails> binaryTask(Supplier<DbSchedulerDeadlineManager> deadlineManagerSupplier) {
        return new Tasks.OneTimeTaskBuilder("AxonDeadline", DbSchedulerBinaryDeadlineDetails.class).execute((taskInstance, context) -> {
            DbSchedulerDeadlineManager deadlineManager = (DbSchedulerDeadlineManager)deadlineManagerSupplier.get();
            if (Objects.isNull(deadlineManager)) {
                throw new DeadlineManagerNotSuppliedException();
            }
            deadlineManager.execute(taskInstance.getId(), (DbSchedulerBinaryDeadlineDetails)taskInstance.getData());
        });
    }

    public static Task<DbSchedulerHumanReadableDeadlineDetails> humanReadableTask(Supplier<DbSchedulerDeadlineManager> deadlineManagerSupplier) {
        return new Tasks.OneTimeTaskBuilder("AxonDeadline", DbSchedulerHumanReadableDeadlineDetails.class).execute((taskInstance, context) -> {
            DbSchedulerDeadlineManager deadlineManager = (DbSchedulerDeadlineManager)deadlineManagerSupplier.get();
            if (Objects.isNull(deadlineManager)) {
                throw new DeadlineManagerNotSuppliedException();
            }
            deadlineManager.execute(taskInstance.getId(), (DbSchedulerHumanReadableDeadlineDetails)taskInstance.getData());
        });
    }

    @Override
    public void cancelSchedule(@Nonnull String deadlineName, @Nonnull String scheduleId) {
        Span span = this.spanFactory.createCancelScheduleSpan(deadlineName, scheduleId);
        this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> this.scheduler.cancel((TaskInstanceId)new DbSchedulerDeadlineToken(scheduleId))));
    }

    @Override
    public void cancelAll(@Nonnull String deadlineName) {
        Span span = this.spanFactory.createCancelAllSpan(deadlineName);
        if (this.useBinaryPojo) {
            this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> this.scheduler.fetchScheduledExecutionsForTask("AxonDeadline", DbSchedulerBinaryDeadlineDetails.class, this.cancelIfBinaryDeadlineMatches(deadlineName))));
        } else {
            this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> this.scheduler.fetchScheduledExecutionsForTask("AxonDeadline", DbSchedulerHumanReadableDeadlineDetails.class, this.cancelIfHumanReadableDeadlineMatches(deadlineName))));
        }
    }

    private Consumer<ScheduledExecution<DbSchedulerBinaryDeadlineDetails>> cancelIfBinaryDeadlineMatches(@Nonnull String deadlineName) {
        return scheduledExecution -> {
            if (deadlineName.equals(((DbSchedulerBinaryDeadlineDetails)scheduledExecution.getData()).getD())) {
                this.scheduler.cancel(scheduledExecution.getTaskInstance());
            }
        };
    }

    private Consumer<ScheduledExecution<DbSchedulerHumanReadableDeadlineDetails>> cancelIfHumanReadableDeadlineMatches(@Nonnull String deadlineName) {
        return scheduledExecution -> {
            if (deadlineName.equals(((DbSchedulerHumanReadableDeadlineDetails)scheduledExecution.getData()).getDeadlineName())) {
                this.scheduler.cancel(scheduledExecution.getTaskInstance());
            }
        };
    }

    @Override
    public void cancelAllWithinScope(@Nonnull String deadlineName, @Nonnull ScopeDescriptor scope) {
        Span span = this.spanFactory.createCancelAllWithinScopeSpan(deadlineName, scope);
        if (this.useBinaryPojo) {
            this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> {
                SerializedObject<byte[]> serializedDescriptor = this.serializer.serialize(scope, byte[].class);
                this.scheduler.fetchScheduledExecutionsForTask("AxonDeadline", DbSchedulerBinaryDeadlineDetails.class, this.cancelIfDeadlineAndScopeMatches(deadlineName, serializedDescriptor.getData()));
            }));
        } else {
            this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> {
                SerializedObject<String> serializedDescriptor = this.serializer.serialize(scope, String.class);
                this.scheduler.fetchScheduledExecutionsForTask("AxonDeadline", DbSchedulerHumanReadableDeadlineDetails.class, this.cancelIfDeadlineAndScopeMatches(deadlineName, serializedDescriptor.getData()));
            }));
        }
    }

    private Consumer<ScheduledExecution<DbSchedulerHumanReadableDeadlineDetails>> cancelIfDeadlineAndScopeMatches(@Nonnull String deadlineName, @Nonnull String scopeDescriptor) {
        return scheduledExecution -> {
            DbSchedulerHumanReadableDeadlineDetails data = (DbSchedulerHumanReadableDeadlineDetails)scheduledExecution.getData();
            if (deadlineName.equals(data.getDeadlineName()) && scopeDescriptor.equals(data.getScopeDescriptor())) {
                this.scheduler.cancel(scheduledExecution.getTaskInstance());
            }
        };
    }

    private Consumer<ScheduledExecution<DbSchedulerBinaryDeadlineDetails>> cancelIfDeadlineAndScopeMatches(@Nonnull String deadlineName, @Nonnull byte[] scopeDescriptor) {
        return scheduledExecution -> {
            DbSchedulerBinaryDeadlineDetails data = (DbSchedulerBinaryDeadlineDetails)scheduledExecution.getData();
            if (deadlineName.equals(data.getD()) && Arrays.equals(scopeDescriptor, data.getS())) {
                this.scheduler.cancel(scheduledExecution.getTaskInstance());
            }
        };
    }

    private void execute(String deadlineId, DbSchedulerBinaryDeadlineDetails deadlineDetails) {
        GenericDeadlineMessage deadlineMessage = deadlineDetails.asDeadLineMessage(this.serializer);
        ScopeDescriptor scopeDescriptor = deadlineDetails.getDeserializedScopeDescriptor(this.serializer);
        this.execute(deadlineId, deadlineDetails.getD(), deadlineMessage, scopeDescriptor);
    }

    private void execute(String deadlineId, DbSchedulerHumanReadableDeadlineDetails deadlineDetails) {
        GenericDeadlineMessage deadlineMessage = deadlineDetails.asDeadLineMessage(this.serializer);
        ScopeDescriptor scopeDescriptor = deadlineDetails.getDeserializedScopeDescriptor(this.serializer);
        this.execute(deadlineId, deadlineDetails.getDeadlineName(), deadlineMessage, scopeDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String deadlineId, String deadlineName, GenericDeadlineMessage deadlineMessage, ScopeDescriptor scopeDescriptor) {
        Span span = this.spanFactory.createExecuteSpan(deadlineName, deadlineId, deadlineMessage).start();
        try (SpanScope ignored = span.makeCurrent();){
            LegacyDefaultUnitOfWork<GenericDeadlineMessage> unitOfWork = new LegacyDefaultUnitOfWork<GenericDeadlineMessage>(deadlineMessage);
            unitOfWork.attachTransaction(this.transactionManager);
            unitOfWork.onRollback(uow -> span.recordException(uow.getExecutionResult().getExceptionResult()));
            DefaultInterceptorChain chain = new DefaultInterceptorChain(unitOfWork, this.handlerInterceptors(), (interceptedDeadlineMessage, ctx) -> {
                this.executeScheduledDeadline((DeadlineMessage<?>)interceptedDeadlineMessage, ctx, scopeDescriptor);
                return null;
            });
            ResultMessage<Object> resultMessage = unitOfWork.executeWithResult(chain::proceedSync);
            if (resultMessage.isExceptional()) {
                Throwable e = resultMessage.exceptionResult();
                span.recordException(e);
                logger.warn("An error occurred while triggering deadline with name [{}].", (Object)deadlineName);
                throw new DeadlineException("Failed to process", e);
            }
        }
        finally {
            span.end();
        }
    }

    private void executeScheduledDeadline(DeadlineMessage<?> deadlineMessage, ProcessingContext context, ScopeDescriptor deadlineScope) {
        this.scopeAwareProvider.provideScopeAwareStream(deadlineScope).filter(scopeAwareComponent -> scopeAwareComponent.canResolve(deadlineScope)).forEach(scopeAwareComponent -> {
            try {
                scopeAwareComponent.send(deadlineMessage, context, deadlineScope);
            }
            catch (Exception e) {
                String exceptionMessage = String.format("Failed to send a DeadlineMessage for scope [%s]", deadlineScope.scopeDescription());
                throw new ExecutionException(exceptionMessage, e);
            }
        });
    }

    public void start() {
        SchedulerState state = this.scheduler.getSchedulerState();
        if (state.isShuttingDown()) {
            logger.warn("Scheduler is shutting down - will not attempting to start");
            return;
        }
        if (state.isStarted()) {
            logger.info("Scheduler already started - will not attempt to start again");
            return;
        }
        logger.info("Triggering scheduler start");
        this.scheduler.start();
    }

    @Override
    public void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            this.scheduler.stop();
        }
    }

    public static class Builder {
        private Scheduler scheduler;
        private ScopeAwareProvider scopeAwareProvider;
        private Serializer serializer;
        private TransactionManager transactionManager = NoTransactionManager.INSTANCE;
        private DeadlineManagerSpanFactory spanFactory = DefaultDeadlineManagerSpanFactory.builder().spanFactory(NoOpSpanFactory.INSTANCE).build();
        private MessageTypeResolver messageTypeResolver = new ClassBasedMessageTypeResolver();
        private boolean useBinaryPojo = true;

        public Builder scheduler(Scheduler scheduler) {
            BuilderUtils.assertNonNull(scheduler, "scheduler may not be null");
            this.scheduler = scheduler;
            return this;
        }

        public Builder scopeAwareProvider(ScopeAwareProvider scopeAwareProvider) {
            BuilderUtils.assertNonNull(scopeAwareProvider, "ScopeAwareProvider may not be null");
            this.scopeAwareProvider = scopeAwareProvider;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull(serializer, "Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder spanFactory(@Nonnull DeadlineManagerSpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "SpanFactory may not be null");
            this.spanFactory = spanFactory;
            return this;
        }

        public Builder useBinaryPojo(boolean useBinaryPojo) {
            this.useBinaryPojo = useBinaryPojo;
            return this;
        }

        public Builder messageNameResolver(MessageTypeResolver messageTypeResolver) {
            BuilderUtils.assertNonNull(messageTypeResolver, "MessageNameResolver may not be null");
            this.messageTypeResolver = messageTypeResolver;
            return this;
        }

        public DbSchedulerDeadlineManager build() {
            return new DbSchedulerDeadlineManager(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.scopeAwareProvider, "The ScopeAwareProvider is a hard requirement and should be provided.");
            BuilderUtils.assertNonNull(this.scheduler, "The Scheduler is a hard requirement and should be provided.");
            BuilderUtils.assertNonNull(this.serializer, "The Serializer is a hard requirement and should be provided.");
        }
    }
}

