/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.configuration.AmbiguousComponentMatchException;
import org.axonframework.configuration.Component;

@Internal
public class Components
implements DescribableComponent {
    private final Map<Component.Identifier<?>, Component<?>> components = new ConcurrentHashMap();

    @Nonnull
    public <C> Optional<Component<C>> get(@Nonnull Component.Identifier<C> identifier) {
        return Optional.ofNullable(this.components.get(identifier)).or(() -> {
            List matches = this.getComponentsAssignableTo(identifier);
            return Optional.ofNullable(matches.isEmpty() ? null : matches.getFirst());
        });
    }

    private <C> List<Component<C>> getComponentsAssignableTo(Component.Identifier<C> identifier) {
        List<Component<C>> matches = this.components.entrySet().stream().filter(entry -> identifier.matches((Component.Identifier)entry.getKey())).map(Map.Entry::getValue).map(component -> component).toList();
        if (matches.size() > 1) {
            throw new AmbiguousComponentMatchException(identifier);
        }
        return matches;
    }

    @Nullable
    public <C> Component<C> put(@Nonnull Component<C> component) {
        return this.components.put(component.identifier(), component);
    }

    @Nonnull
    public <C> Component<C> computeIfAbsent(@Nonnull Component.Identifier<C> identifier, @Nonnull Supplier<Component<C>> compute) {
        return this.components.computeIfAbsent(identifier, (? super K i) -> (Component)compute.get());
    }

    public boolean contains(@Nonnull Component.Identifier<?> identifier) {
        return identifier.name() != null ? this.components.containsKey(identifier) : this.components.keySet().stream().anyMatch(identifier::matchesType);
    }

    public Set<Component.Identifier<?>> identifiers() {
        return Set.copyOf(this.components.keySet());
    }

    public <C> boolean replace(@Nonnull Component.Identifier<C> identifier, @Nonnull UnaryOperator<Component<C>> replacement) {
        Component newValue = this.components.computeIfPresent(identifier, (i, c) -> (Component)replacement.apply((Component)c));
        return newValue != null;
    }

    public void postProcessComponents(@Nonnull Consumer<Component<?>> processor) {
        Objects.requireNonNull(processor, "The component post processor must be null.");
        this.components.values().forEach(processor);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("components", this.components);
    }
}

