/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.common.ReflectionUtils;

public class ConstructorUtils {
    public static <T> Supplier<T> getConstructorFunctionWithZeroArguments(@Nonnull Class<T> type) {
        try {
            Constructor constructor = type.getDeclaredConstructor(new Class[0]);
            ReflectionUtils.ensureAccessible(constructor);
            return () -> ConstructorUtils.doConstructionWithOptionalArgument(type, null, constructor);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No suitable constructor found for entity of type [%s] with zero arguments".formatted(type.getName()));
        }
    }

    public static <T, A> Function<A, T> factoryForTypeWithOptionalArgument(@Nonnull Class<T> type, @Nonnull Class<? extends A> argumentClass) {
        Constructor constructor = ConstructorUtils.getConstructorWithOptionalArgumentOfType(type, argumentClass);
        return arg -> ConstructorUtils.doConstructionWithOptionalArgument(type, arg, constructor);
    }

    private static <T> Constructor<T> getConstructorWithOptionalArgumentOfType(@Nonnull Class<T> type, @Nonnull Class<?> argument) {
        return Arrays.stream(type.getDeclaredConstructors()).filter(constructor -> ConstructorUtils.constructorHasZeroOrExactlyThisArgument(constructor, argument)).max(Comparator.comparingInt(Constructor::getParameterCount)).orElseThrow(() -> new IllegalArgumentException("No suitable constructor found for entity of type [%s] with optional argument of type [%s]".formatted(type.getName(), argument.getName())));
    }

    private static boolean constructorHasZeroOrExactlyThisArgument(@Nonnull Constructor<?> constructor, @Nonnull Class<?> argument) {
        if (constructor.getParameterCount() == 0) {
            return true;
        }
        return constructor.getParameterCount() == 1 && constructor.getParameterTypes()[0].isAssignableFrom(argument);
    }

    private static <T> T doConstructionWithOptionalArgument(Class<T> type, Object argument, Constructor<T> constructor) {
        try {
            ReflectionUtils.ensureAccessible(constructor);
            if (constructor.getParameterCount() == 0) {
                return constructor.newInstance(new Object[0]);
            }
            return constructor.newInstance(argument);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Error creating %s".formatted(type), e);
        }
    }

    private ConstructorUtils() {
    }
}

