/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.configuration.ComponentNotFoundException;

public interface Configuration
extends DescribableComponent {
    @Nonnull
    default public <C> C getComponent(@Nonnull Class<C> type) {
        return this.getComponent(type, (String)null);
    }

    @Nonnull
    default public <C> C getComponent(@Nonnull Class<C> type, @Nullable String name) {
        return this.getOptionalComponent(type, name).orElseThrow(() -> new ComponentNotFoundException(type, name));
    }

    default public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> type) {
        return this.getOptionalComponent(type, null);
    }

    public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> var1, @Nullable String var2);

    default public boolean hasComponent(@Nonnull Class<?> type) {
        return this.hasComponent(type, null);
    }

    default public boolean hasComponent(@Nonnull Class<?> type, @Nullable String name) {
        return this.getOptionalComponent(type, name).isPresent();
    }

    @Nonnull
    default public <C> C getComponent(@Nonnull Class<C> type, @Nonnull Supplier<C> defaultImpl) {
        return this.getComponent(type, null, defaultImpl);
    }

    @Nonnull
    public <C> C getComponent(@Nonnull Class<C> var1, @Nullable String var2, @Nonnull Supplier<C> var3);

    public List<Configuration> getModuleConfigurations();

    public Optional<Configuration> getModuleConfiguration(@Nonnull String var1);

    @Nullable
    public Configuration getParent();
}

