/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.distributed.Connector;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class DistributedCommandBus
implements CommandBus {
    private final CommandBus delegate;
    private final Connector connector;

    public DistributedCommandBus(@Nonnull CommandBus delegate, @Nonnull Connector connector) {
        this.delegate = Objects.requireNonNull(delegate, "Given CommandBus delegate cannot be null.");
        this.connector = Objects.requireNonNull(connector, "Given Connector cannot be null.");
        connector.onIncomingCommand((command, callback) -> delegate.dispatch((CommandMessage<?>)command, null).whenComplete((chr, e) -> {
            if (e == null) {
                callback.success((Message<?>)chr);
            } else {
                callback.error((Throwable)e);
            }
        }));
    }

    @Override
    public DistributedCommandBus subscribe(@Nonnull QualifiedName name, @Nonnull CommandHandler handler) {
        CommandHandler commandHandler = Objects.requireNonNull(handler, "Given handler cannot be null.");
        this.delegate.subscribe(name, commandHandler);
        this.connector.subscribe(name.toString(), 100);
        return this;
    }

    @Override
    public CompletableFuture<CommandResultMessage<?>> dispatch(@Nonnull CommandMessage<?> command, @Nullable ProcessingContext processingContext) {
        return this.connector.dispatch(command, processingContext);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("connector", this.connector);
    }
}

