/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import javax.annotation.Nonnull;
import org.axonframework.eventhandling.ErrorContext;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.EventProcessingException;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;

public enum PropagatingErrorHandler implements ErrorHandler,
ListenerInvocationErrorHandler
{
    INSTANCE;


    public static PropagatingErrorHandler instance() {
        return INSTANCE;
    }

    @Override
    public void onError(@Nonnull Exception exception, @Nonnull EventMessage<?> event, @Nonnull EventMessageHandler eventHandler) throws Exception {
        throw exception;
    }

    @Override
    public void handleError(@Nonnull ErrorContext errorContext) throws Exception {
        Throwable error = errorContext.error();
        if (error instanceof Error) {
            throw (Error)error;
        }
        if (error instanceof Exception) {
            throw (Exception)error;
        }
        throw new EventProcessingException("An error occurred while handling an event", error);
    }
}

