/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.pooled;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackerStatus;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.pooled.CoordinatorTask;
import org.axonframework.eventhandling.pooled.WorkPackage;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SplitTask
extends CoordinatorTask {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String name;
    private final int segmentId;
    private final Map<Integer, WorkPackage> workPackages;
    private final TokenStore tokenStore;
    private final TransactionManager transactionManager;

    SplitTask(CompletableFuture<Boolean> result, String name, int segmentId, Map<Integer, WorkPackage> workPackages, TokenStore tokenStore, TransactionManager transactionManager) {
        super(result, name);
        this.name = name;
        this.segmentId = segmentId;
        this.workPackages = workPackages;
        this.tokenStore = tokenStore;
        this.transactionManager = transactionManager;
    }

    @Override
    protected CompletableFuture<Boolean> task() {
        logger.debug("Processor [{}] will perform split instruction for segment {}.", (Object)this.name, (Object)this.segmentId);
        WorkPackage workPackage = this.workPackages.remove(this.segmentId);
        return workPackage != null ? this.abortAndSplit(workPackage) : this.fetchSegmentAndSplit(this.segmentId);
    }

    private CompletableFuture<Boolean> abortAndSplit(WorkPackage workPackage) {
        return workPackage.abort(null).thenApply(e -> this.splitAndRelease(workPackage.segment()));
    }

    private CompletableFuture<Boolean> fetchSegmentAndSplit(int segmentId) {
        return CompletableFuture.completedFuture(this.transactionManager.fetchInTransaction(() -> {
            int[] segments = this.tokenStore.fetchSegments(this.name);
            Segment segmentToSplit = Segment.computeSegment(segmentId, segments);
            return this.splitAndRelease(segmentToSplit);
        }));
    }

    private boolean splitAndRelease(Segment segmentToSplit) {
        this.transactionManager.executeInTransaction(() -> {
            TrackingToken tokenToSplit = this.tokenStore.fetchToken(this.name, segmentToSplit.getSegmentId());
            TrackerStatus[] splitStatuses = TrackerStatus.split(segmentToSplit, tokenToSplit);
            this.tokenStore.initializeSegment(splitStatuses[1].getTrackingToken(), this.name, splitStatuses[1].getSegment().getSegmentId());
            this.tokenStore.releaseClaim(this.name, splitStatuses[0].getSegment().getSegmentId());
            logger.info("Processor [{}] successfully split {} into {} and {}.", new Object[]{this.name, segmentToSplit, splitStatuses[0].getSegment(), splitStatuses[1].getSegment()});
        });
        return true;
    }

    @Override
    String getDescription() {
        return "Split Task for segment " + this.segmentId;
    }
}

