/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.queryhandling.FluxSinkWrapper;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.UpdateHandlerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.FluxSink;

public class SimpleQueryUpdateEmitter
implements QueryUpdateEmitter {
    private static final Logger logger = LoggerFactory.getLogger(SimpleQueryUpdateEmitter.class);
    private static final String QUERY_UPDATE_TASKS_RESOURCE_KEY = "/update-tasks";
    private final MessageMonitor<? super SubscriptionQueryUpdateMessage<?>> updateMessageMonitor;
    private final ConcurrentMap<SubscriptionQueryMessage<?, ?, ?>, FluxSinkWrapper<?>> updateHandlers = new ConcurrentHashMap();
    private final List<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();

    protected SimpleQueryUpdateEmitter(Builder builder) {
        builder.validate();
        this.updateMessageMonitor = builder.updateMessageMonitor;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean queryUpdateHandlerRegistered(SubscriptionQueryMessage<?, ?, ?> query) {
        return this.updateHandlers.keySet().stream().anyMatch(m -> m.getIdentifier().equals(query.getIdentifier()));
    }

    @Override
    public <U> UpdateHandlerRegistration<U> registerUpdateHandler(SubscriptionQueryMessage<?, ?, ?> query, SubscriptionQueryBackpressure backpressure, int updateBufferSize) {
        EmitterProcessor processor = EmitterProcessor.create((int)updateBufferSize);
        FluxSink sink = processor.sink(backpressure.getOverflowStrategy());
        sink.onDispose(() -> {
            FluxSinkWrapper cfr_ignored_0 = (FluxSinkWrapper)this.updateHandlers.remove(query);
        });
        FluxSinkWrapper fluxSinkWrapper = new FluxSinkWrapper(sink);
        this.updateHandlers.put(query, fluxSinkWrapper);
        Registration registration = () -> {
            this.updateHandlers.remove(query);
            return true;
        };
        return new UpdateHandlerRegistration(registration, processor.replay(updateBufferSize).autoConnect(), fluxSinkWrapper::complete);
    }

    @Override
    public <U> void emit(Predicate<SubscriptionQueryMessage<?, ?, U>> filter, SubscriptionQueryUpdateMessage<U> update) {
        this.runOnAfterCommitOrNow(() -> this.doEmit(filter, this.intercept(update)));
    }

    private <U> SubscriptionQueryUpdateMessage<U> intercept(SubscriptionQueryUpdateMessage<U> message) {
        SubscriptionQueryUpdateMessage<U> intercepted = message;
        for (MessageDispatchInterceptor<SubscriptionQueryUpdateMessage<?>> interceptor : this.dispatchInterceptors) {
            intercepted = interceptor.handle(intercepted);
        }
        return intercepted;
    }

    @Override
    public void complete(Predicate<SubscriptionQueryMessage<?, ?, ?>> filter) {
        this.runOnAfterCommitOrNow(() -> this.doComplete(filter));
    }

    @Override
    public void completeExceptionally(Predicate<SubscriptionQueryMessage<?, ?, ?>> filter, Throwable cause) {
        this.runOnAfterCommitOrNow(() -> this.doCompleteExceptionally(filter, cause));
    }

    @Override
    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage<?>> interceptor) {
        this.dispatchInterceptors.add(interceptor);
        return () -> this.dispatchInterceptors.remove(interceptor);
    }

    private <U> void doEmit(Predicate<SubscriptionQueryMessage<?, ?, U>> filter, SubscriptionQueryUpdateMessage<U> update) {
        this.updateHandlers.keySet().stream().filter(sqm -> filter.test((SubscriptionQueryMessage)sqm)).forEach(query -> Optional.ofNullable(this.updateHandlers.get(query)).ifPresent(uh -> this.doEmit((SubscriptionQueryMessage<?, ?, ?>)query, (FluxSinkWrapper<?>)uh, update)));
    }

    private <U> void doEmit(SubscriptionQueryMessage<?, ?, ?> query, FluxSinkWrapper<?> updateHandler, SubscriptionQueryUpdateMessage<U> update) {
        MessageMonitor.MonitorCallback monitorCallback = this.updateMessageMonitor.onMessageIngested(update);
        try {
            updateHandler.next(update);
            monitorCallback.reportSuccess();
        }
        catch (Exception e) {
            logger.info("An error occurred while trying to emit an update to a query '{}'. The subscription will be cancelled. Exception summary: {}", (Object)query.getQueryName(), (Object)e.toString());
            monitorCallback.reportFailure(e);
            this.updateHandlers.remove(query);
            this.emitError(query, e, updateHandler);
        }
    }

    private void doComplete(Predicate<SubscriptionQueryMessage<?, ?, ?>> filter) {
        this.updateHandlers.keySet().stream().filter(filter).forEach(query -> Optional.ofNullable(this.updateHandlers.get(query)).ifPresent(updateHandler -> {
            try {
                updateHandler.complete();
            }
            catch (Exception e) {
                this.emitError((SubscriptionQueryMessage<?, ?, ?>)query, e, (FluxSinkWrapper<?>)updateHandler);
            }
        }));
    }

    private void emitError(SubscriptionQueryMessage<?, ?, ?> query, Throwable cause, FluxSinkWrapper<?> updateHandler) {
        try {
            updateHandler.error(cause);
        }
        catch (Exception e) {
            logger.error(String.format("An error happened while trying to inform update handler about the error. Query: %s", query));
        }
    }

    private void doCompleteExceptionally(Predicate<SubscriptionQueryMessage<?, ?, ?>> filter, Throwable cause) {
        this.updateHandlers.keySet().stream().filter(filter).forEach(query -> Optional.ofNullable(this.updateHandlers.get(query)).ifPresent(updateHandler -> this.emitError((SubscriptionQueryMessage<?, ?, ?>)query, cause, (FluxSinkWrapper<?>)updateHandler)));
    }

    private void runOnAfterCommitOrNow(Runnable queryUpdateTask) {
        if (this.inStartedPhaseOfUnitOfWork()) {
            UnitOfWork<?> unitOfWork = CurrentUnitOfWork.get();
            unitOfWork.getOrComputeResource(this.toString() + QUERY_UPDATE_TASKS_RESOURCE_KEY, resourceKey -> {
                ArrayList queryUpdateTasks = new ArrayList();
                unitOfWork.afterCommit(uow -> queryUpdateTasks.forEach(Runnable::run));
                return queryUpdateTasks;
            }).add(queryUpdateTask);
        } else {
            queryUpdateTask.run();
        }
    }

    private boolean inStartedPhaseOfUnitOfWork() {
        return CurrentUnitOfWork.isStarted() && UnitOfWork.Phase.STARTED.equals((Object)CurrentUnitOfWork.get().phase());
    }

    @Override
    public Set<SubscriptionQueryMessage<?, ?, ?>> activeSubscriptions() {
        return Collections.unmodifiableSet(this.updateHandlers.keySet());
    }

    public static class Builder {
        private MessageMonitor<? super SubscriptionQueryUpdateMessage<?>> updateMessageMonitor = NoOpMessageMonitor.INSTANCE;

        public Builder updateMessageMonitor(MessageMonitor<? super SubscriptionQueryUpdateMessage<?>> updateMessageMonitor) {
            BuilderUtils.assertNonNull(updateMessageMonitor, "MessageMonitor may not be null");
            this.updateMessageMonitor = updateMessageMonitor;
            return this;
        }

        public SimpleQueryUpdateEmitter build() {
            return new SimpleQueryUpdateEmitter(this);
        }

        protected void validate() throws AxonConfigurationException {
        }
    }
}

