/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.axonframework.updates.api.ArtifactAvailableUpgrade;
import org.axonframework.updates.api.DetectedVulnerability;
import org.axonframework.updates.api.DetectedVulnerabilitySeverity;

public class UpdateCheckResponse {
    private final int checkInterval;
    private final List<ArtifactAvailableUpgrade> upgrades;
    private final List<DetectedVulnerability> vulnerabilities;

    public UpdateCheckResponse(int checkInterval, List<ArtifactAvailableUpgrade> upgrades, List<DetectedVulnerability> vulnerabilities) {
        this.checkInterval = checkInterval;
        this.upgrades = upgrades;
        this.vulnerabilities = vulnerabilities;
    }

    public int checkInterval() {
        return this.checkInterval;
    }

    public List<ArtifactAvailableUpgrade> upgrades() {
        return this.upgrades;
    }

    public List<DetectedVulnerability> vulnerabilities() {
        return this.vulnerabilities;
    }

    public static UpdateCheckResponse fromRequest(String body) {
        String[] lines;
        int checkInterval = 86400;
        ArrayList<ArtifactAvailableUpgrade> upgrades = new ArrayList<ArtifactAvailableUpgrade>();
        ArrayList<DetectedVulnerability> vulnerabilities = new ArrayList<DetectedVulnerability>();
        if (body == null || body.isEmpty()) {
            return new UpdateCheckResponse(checkInterval, Collections.emptyList(), Collections.emptyList());
        }
        block10: for (String line : lines = body.split("\\r?\\n")) {
            String[] parts;
            if (line.isEmpty() || (parts = line.split("=", 2)).length < 2) continue;
            String key = parts[0].trim();
            String value = parts[1].trim();
            switch (key) {
                case "cd": {
                    checkInterval = UpdateCheckResponse.parseCheckInterval(value);
                    continue block10;
                }
                case "vul": {
                    UpdateCheckResponse.parseVulnerability(value, vulnerabilities);
                    continue block10;
                }
                case "upd": {
                    UpdateCheckResponse.parseUpdate(value, vulnerabilities, upgrades);
                }
            }
        }
        return new UpdateCheckResponse(checkInterval, upgrades, vulnerabilities);
    }

    private static void parseUpdate(String val, List<DetectedVulnerability> vulnerabilities, List<ArtifactAvailableUpgrade> upgrades) {
        String[] parts = UpdateCheckResponse.parseIntoParts(val);
        if (parts.length == 3) {
            String groupId = parts[0];
            String artifactId = parts[1];
            String latestVersion = parts[2];
            upgrades.add(new ArtifactAvailableUpgrade(groupId, artifactId, latestVersion));
        }
    }

    private static void parseVulnerability(String val, List<DetectedVulnerability> vulnerabilities) {
        String[] parts = UpdateCheckResponse.parseIntoParts(val);
        if (parts.length == 5) {
            String groupId = parts[0];
            String artifactId = parts[1];
            String fixVersion = parts[2];
            DetectedVulnerabilitySeverity severity = UpdateCheckResponse.parseVulnerability(parts[3]);
            String moreInformationUrl = parts[4];
            vulnerabilities.add(new DetectedVulnerability(groupId, artifactId, severity, fixVersion, moreInformationUrl));
        }
    }

    private static String[] parseIntoParts(String val) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c == ':' && !inQuotes) {
                parts.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        parts.add(current.toString());
        return parts.toArray(new String[0]);
    }

    private static DetectedVulnerabilitySeverity parseVulnerability(String value) {
        DetectedVulnerabilitySeverity severity;
        try {
            severity = DetectedVulnerabilitySeverity.valueOf(value);
        }
        catch (Exception e) {
            severity = DetectedVulnerabilitySeverity.UNKNOWN;
        }
        return severity;
    }

    private static int parseCheckInterval(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return 86400;
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateCheckResponse that = (UpdateCheckResponse)o;
        return this.checkInterval == that.checkInterval && Objects.equals(this.upgrades, that.upgrades) && Objects.equals(this.vulnerabilities, that.vulnerabilities);
    }

    public int hashCode() {
        return Objects.hash(this.checkInterval, this.upgrades, this.vulnerabilities);
    }

    public String toString() {
        return "UpdateCheckResponse{checkInterval=" + this.checkInterval + ", upgrades=" + this.upgrades + ", vulnerabilities=" + this.vulnerabilities + '}';
    }
}

