/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecordBase;
import org.axonframework.common.BuilderUtils;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.avro.AvroSerializerStrategy;
import org.axonframework.serialization.avro.AvroSerializerStrategyConfig;
import org.axonframework.serialization.avro.AvroUtil;
import org.axonframework.serialization.avro.SchemaIncompatibilityChecker;

public class SpecificRecordBaseSerializerStrategy
implements AvroSerializerStrategy {
    private final SchemaStore schemaStore;
    private final RevisionResolver revisionResolver;
    private final SchemaIncompatibilityChecker schemaIncompatibilityChecker;
    private AvroSerializerStrategyConfig avroSerializerStrategyConfig = AvroSerializerStrategyConfig.builder().build();

    public SpecificRecordBaseSerializerStrategy(SchemaStore schemaStore, RevisionResolver revisionResolver, SchemaIncompatibilityChecker schemaIncompatibilityChecker) {
        this.schemaStore = schemaStore;
        this.revisionResolver = revisionResolver;
        this.schemaIncompatibilityChecker = schemaIncompatibilityChecker;
    }

    @Override
    @Nonnull
    public SerializedObject<byte[]> serializeToSingleObjectEncoded(@Nonnull Object object) {
        byte[] bytes;
        if (!(object instanceof SpecificRecordBase)) {
            throw new SerializationException("Expected object to be instance of SpecificRecordBase but it was " + object.getClass().getCanonicalName());
        }
        SpecificRecordBase record = (SpecificRecordBase)object;
        BinaryMessageEncoder encoder = new BinaryMessageEncoder((GenericData)record.getSpecificData(), record.getSchema());
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            encoder.encode((Object)record, (OutputStream)outputStream);
            bytes = outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException("Failed to serialize specific record", e);
        }
        return new SimpleSerializedObject<byte[]>(bytes, byte[].class, new SimpleSerializedType(object.getClass().getCanonicalName(), this.revisionResolver.revisionOf(object.getClass())));
    }

    @Override
    @Nonnull
    public <T> T deserializeFromSingleObjectEncoded(@Nonnull SerializedObject<byte[]> serializedObject, @Nonnull Class<T> readerType) {
        if (!SpecificRecordBase.class.isAssignableFrom(readerType)) {
            throw new SerializationException("Expected reader type to be assignable from SpecificRecordBase but it was " + readerType.getCanonicalName());
        }
        Class<SpecificRecordBase> specificRecordBaseClass = readerType;
        long fingerprint = AvroUtil.fingerprint(serializedObject.getData());
        Schema writerSchema = this.schemaStore.findByFingerprint(fingerprint);
        if (writerSchema == null) {
            throw AvroUtil.createExceptionNoSchemaFound(readerType, fingerprint);
        }
        SpecificData readerSpecificData = SpecificData.getForClass(specificRecordBaseClass);
        Schema readerSchema = AvroUtil.getClassSchemaChecked(specificRecordBaseClass);
        if (this.avroSerializerStrategyConfig.performAvroCompatibilityCheck()) {
            this.schemaIncompatibilityChecker.assertSchemaCompatibility(readerType, readerSchema, writerSchema, this.avroSerializerStrategyConfig.includeSchemasInStackTraces());
        }
        BinaryMessageDecoder decoder = new BinaryMessageDecoder((GenericData)readerSpecificData, readerSchema);
        decoder.addSchema(writerSchema);
        try {
            return (T)decoder.decode(serializedObject.getData());
        }
        catch (IOException | AvroRuntimeException e) {
            throw AvroUtil.createExceptionFailedToDeserialize(readerType, readerSchema, writerSchema, (Exception)e, this.avroSerializerStrategyConfig.includeSchemasInStackTraces());
        }
    }

    @Override
    @Nonnull
    public <T> T deserializeFromGenericRecord(@Nonnull SerializedObject<GenericRecord> serializedObject, @Nonnull Class<T> readerType) {
        if (!SpecificRecordBase.class.isAssignableFrom(readerType)) {
            throw new SerializationException("Expected reader type to be assignable from SpecificRecordBase but it was " + readerType.getCanonicalName());
        }
        Schema writerSchema = serializedObject.getData().getSchema();
        SpecificData readerSpecificData = SpecificData.getForClass(readerType);
        Schema readerSchema = readerSpecificData.getSchema(readerType);
        if (this.avroSerializerStrategyConfig.performAvroCompatibilityCheck()) {
            this.schemaIncompatibilityChecker.assertSchemaCompatibility(readerType, readerSchema, writerSchema, this.avroSerializerStrategyConfig.includeSchemasInStackTraces());
        }
        SpecificRecordBase decoded = (SpecificRecordBase)readerSpecificData.deepCopy(writerSchema, (Object)serializedObject.getData());
        return (T)decoded;
    }

    @Override
    public boolean test(@Nonnull Class<?> payloadType) {
        return SpecificRecordBase.class.isAssignableFrom(payloadType);
    }

    @Override
    public void applyConfig(@Nonnull AvroSerializerStrategyConfig avroSerializerStrategyConfig) {
        BuilderUtils.assertNonNull(avroSerializerStrategyConfig, "AvroSerializerStrategyConfig may not be null");
        this.avroSerializerStrategyConfig = avroSerializerStrategyConfig;
    }
}

