/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.TrackingToken;

public class GlobalSequenceTrackingToken
implements TrackingToken,
Comparable<GlobalSequenceTrackingToken>,
Serializable {
    private static final long serialVersionUID = -3658606104934080049L;
    private final long globalIndex;

    @JsonCreator
    public GlobalSequenceTrackingToken(@JsonProperty(value="globalIndex") long globalIndex) {
        this.globalIndex = globalIndex;
    }

    public long getGlobalIndex() {
        return this.globalIndex;
    }

    public GlobalSequenceTrackingToken offsetBy(int offset) {
        return new GlobalSequenceTrackingToken(this.globalIndex + (long)offset);
    }

    public GlobalSequenceTrackingToken next() {
        return this.offsetBy(1);
    }

    @Override
    public TrackingToken lowerBound(TrackingToken other) {
        Assert.isTrue(other instanceof GlobalSequenceTrackingToken, () -> "Incompatible token type provided.");
        GlobalSequenceTrackingToken otherToken = (GlobalSequenceTrackingToken)other;
        if (otherToken.globalIndex < this.globalIndex) {
            return otherToken;
        }
        return this;
    }

    @Override
    public TrackingToken upperBound(TrackingToken other) {
        Assert.isTrue(other instanceof GlobalSequenceTrackingToken, () -> "Incompatible token type provided.");
        if (((GlobalSequenceTrackingToken)other).globalIndex > this.globalIndex) {
            return other;
        }
        return this;
    }

    @Override
    public boolean covers(TrackingToken other) {
        Assert.isTrue(other instanceof GlobalSequenceTrackingToken, () -> "Incompatible token type provided.");
        GlobalSequenceTrackingToken otherToken = (GlobalSequenceTrackingToken)other;
        return otherToken.globalIndex <= this.globalIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSequenceTrackingToken that = (GlobalSequenceTrackingToken)o;
        return this.globalIndex == that.globalIndex;
    }

    public int hashCode() {
        return Objects.hash(this.globalIndex);
    }

    public String toString() {
        return "IndexTrackingToken{globalIndex=" + this.globalIndex + '}';
    }

    @Override
    public int compareTo(GlobalSequenceTrackingToken o) {
        return Long.compare(this.globalIndex, o.globalIndex);
    }
}

