/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.Segment;

public class MultiEventHandlerInvoker
implements EventHandlerInvoker {
    private final List<EventHandlerInvoker> delegates;

    public MultiEventHandlerInvoker(EventHandlerInvoker ... delegates) {
        this(Arrays.asList(delegates));
    }

    public MultiEventHandlerInvoker(List<EventHandlerInvoker> delegates) {
        this.delegates = this.flatten(delegates);
    }

    private List<EventHandlerInvoker> flatten(List<EventHandlerInvoker> invokers) {
        ArrayList<EventHandlerInvoker> flattened = new ArrayList<EventHandlerInvoker>();
        for (EventHandlerInvoker invoker : invokers) {
            if (invoker instanceof MultiEventHandlerInvoker) {
                flattened.addAll(((MultiEventHandlerInvoker)invoker).delegates());
                continue;
            }
            flattened.add(invoker);
        }
        return flattened;
    }

    public List<EventHandlerInvoker> delegates() {
        return Collections.unmodifiableList(this.delegates);
    }

    @Override
    public boolean canHandle(EventMessage<?> eventMessage, Segment segment) {
        return this.delegates.stream().anyMatch(i -> i.canHandle(eventMessage, segment));
    }

    @Override
    public void handle(EventMessage<?> message, Segment segment) throws Exception {
        for (EventHandlerInvoker i : this.delegates) {
            if (!i.canHandle(message, segment)) continue;
            i.handle(message, segment);
        }
    }

    @Override
    public boolean supportsReset() {
        return this.delegates.stream().anyMatch(EventHandlerInvoker::supportsReset);
    }

    @Override
    public void performReset() {
        this.delegates.stream().filter(EventHandlerInvoker::supportsReset).forEach(EventHandlerInvoker::performReset);
    }
}

