/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.function.Function;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.config.Component;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.config.SagaConfiguration;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.modelling.saga.AbstractSagaManager;
import org.axonframework.modelling.saga.AnnotatedSagaManager;
import org.axonframework.modelling.saga.SagaManagerSpanFactory;
import org.axonframework.modelling.saga.SagaRepository;
import org.axonframework.modelling.saga.repository.AnnotatedSagaRepository;
import org.axonframework.modelling.saga.repository.SagaStore;

public class SagaConfigurer<T> {
    private final Class<T> type;
    private Function<LegacyConfiguration, AbstractSagaManager<T>> managerBuilder;
    private Function<LegacyConfiguration, SagaRepository<T>> repositoryBuilder;
    private Function<LegacyConfiguration, SagaStore<? super T>> storeBuilder = c -> c.eventProcessingConfiguration().sagaStore();
    private SagaConfigurationImpl<T> sagaConfig;

    public static <T> SagaConfigurer<T> forType(Class<T> sagaType) {
        return new SagaConfigurer<T>(sagaType);
    }

    protected SagaConfigurer(Class<T> type) {
        this.verifyNotInitialized();
        BuilderUtils.assertNonNull(type, (String)"Saga type is not allowed to be null");
        this.type = type;
    }

    public SagaConfigurer<T> configureSagaManager(Function<LegacyConfiguration, AbstractSagaManager<T>> managerBuilder) {
        this.verifyNotInitialized();
        BuilderUtils.assertNonNull(managerBuilder, (String)"SagaManager builder is not allowed to be null");
        this.managerBuilder = managerBuilder;
        return this;
    }

    public SagaConfigurer<T> configureRepository(Function<LegacyConfiguration, SagaRepository<T>> repositoryBuilder) {
        this.verifyNotInitialized();
        BuilderUtils.assertNonNull(repositoryBuilder, (String)"SagaRepository builder is not allowed to be null");
        this.repositoryBuilder = repositoryBuilder;
        return this;
    }

    public SagaConfigurer<T> configureSagaStore(Function<LegacyConfiguration, SagaStore<? super T>> storeBuilder) {
        this.verifyNotInitialized();
        BuilderUtils.assertNonNull(storeBuilder, (String)"SagaStore builder is not allowed to be null");
        this.storeBuilder = storeBuilder;
        return this;
    }

    private void verifyNotInitialized() {
        if (this.sagaConfig != null) {
            throw new AxonConfigurationException("SagaConfiguration has already been created. Cannot make modifications.");
        }
    }

    public SagaConfiguration<T> initialize(LegacyConfiguration configuration) {
        if (this.sagaConfig == null) {
            this.sagaConfig = new SagaConfigurationImpl(this);
            this.sagaConfig.initialize(configuration);
        }
        return this.sagaConfig;
    }

    private static class SagaConfigurationImpl<S>
    implements SagaConfiguration<S> {
        private final SagaConfigurer<S> configurer;
        private LegacyConfiguration config;
        private Component<AbstractSagaManager<S>> manager;
        private Component<SagaRepository<S>> repository;
        private Component<SagaStore<? super S>> store;

        protected SagaConfigurationImpl(SagaConfigurer<S> sagaConfigurer) {
            this.configurer = sagaConfigurer;
        }

        @Override
        public Class<S> type() {
            return this.configurer.type;
        }

        @Override
        public AbstractSagaManager<S> manager() {
            this.ensureInitialized();
            return this.manager.get();
        }

        @Override
        public SagaRepository<S> repository() {
            this.ensureInitialized();
            return this.repository.get();
        }

        @Override
        public SagaStore<? super S> store() {
            this.ensureInitialized();
            return this.store.get();
        }

        @Override
        public ListenerInvocationErrorHandler listenerInvocationErrorHandler() {
            this.ensureInitialized();
            return this.config.eventProcessingConfiguration().listenerInvocationErrorHandler(this.processingGroup());
        }

        @Override
        public String processingGroup() {
            this.ensureInitialized();
            return this.config.eventProcessingConfiguration().sagaProcessingGroup(this.configurer.type);
        }

        private void initialize(LegacyConfiguration configuration) {
            this.config = configuration;
            String managerName = this.configurer.type.getSimpleName() + "Manager";
            String repositoryName = this.configurer.type.getSimpleName() + "Repository";
            this.store = new Component(configuration, "sagaStore", this.configurer.storeBuilder);
            Function repositoryBuilder = this.configurer.repositoryBuilder;
            if (repositoryBuilder == null) {
                repositoryBuilder = c -> AnnotatedSagaRepository.builder().sagaType(this.configurer.type).sagaStore(this.store.get()).resourceInjector(c.resourceInjector()).parameterResolverFactory(c.parameterResolverFactory()).handlerDefinition(c.handlerDefinition(this.configurer.type)).build();
            }
            this.repository = new Component(configuration, repositoryName, repositoryBuilder);
            Function managerBuilder = this.configurer.managerBuilder;
            if (managerBuilder == null) {
                managerBuilder = c -> {
                    EventProcessingConfiguration eventProcessingConfiguration = c.eventProcessingConfiguration();
                    return AnnotatedSagaManager.builder().sagaType(this.configurer.type).sagaRepository(this.repository.get()).parameterResolverFactory(c.parameterResolverFactory()).handlerDefinition(c.handlerDefinition(this.configurer.type)).listenerInvocationErrorHandler(eventProcessingConfiguration.listenerInvocationErrorHandler(this.processingGroup())).spanFactory(configuration.getComponent(SagaManagerSpanFactory.class)).build();
                };
            }
            this.manager = new Component(configuration, managerName, managerBuilder);
        }

        private void ensureInitialized() {
            Assert.state((this.config != null ? 1 : 0) != 0, () -> "Configuration is not initialized yet");
        }
    }
}

