/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import org.axonframework.common.Assert;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.config.MessageMonitorFactory;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;

class MessageMonitorFactoryBuilder {
    private final Comparator<Class<?>> classComparator = Comparator.comparing(Class::getName).thenComparingInt(c -> c.getClassLoader().hashCode());
    private final Map<String, SortedMap<Class<?>, MessageMonitorFactory>> forNameFactories = new HashMap();
    private final SortedMap<Class<?>, MessageMonitorFactory> forTypeFactories = new TreeMap(this.classComparator);
    private MessageMonitorFactory defaultFactory = (configuration, type, name) -> NoOpMessageMonitor.instance();
    private boolean built = false;

    MessageMonitorFactoryBuilder() {
    }

    MessageMonitorFactoryBuilder add(Class<?> componentType, String componentName, MessageMonitorFactory messageMonitorFactory) {
        this.assertNotBuilt();
        Assert.notNull(componentType, () -> "componentType may not be null");
        Assert.notNull((Object)componentName, () -> "componentName may not be null");
        Assert.notNull((Object)messageMonitorFactory, () -> "messageMonitorFactory may not be null");
        Map mapByType = this.forNameFactories.computeIfAbsent(componentName, name -> new TreeMap(this.classComparator));
        mapByType.put(componentType, messageMonitorFactory);
        return this;
    }

    MessageMonitorFactoryBuilder add(Class<?> componentType, MessageMonitorFactory messageMonitorFactory) {
        this.assertNotBuilt();
        Assert.notNull(componentType, () -> "componentType may not be null");
        Assert.notNull((Object)messageMonitorFactory, () -> "messageMonitorFactory may not be null");
        this.forTypeFactories.put(componentType, messageMonitorFactory);
        return this;
    }

    MessageMonitorFactoryBuilder add(MessageMonitorFactory defaultFactory) {
        this.assertNotBuilt();
        Assert.notNull((Object)defaultFactory, () -> "defaultFactory may not be null");
        this.defaultFactory = defaultFactory;
        return this;
    }

    BiFunction<Class<?>, String, MessageMonitor<Message<?>>> build(LegacyConfiguration configuration) {
        this.assertNotBuilt();
        this.built = true;
        return (type, name) -> {
            MessageMonitorFactory factory = this.getFactoryForType(this.forNameFactories.get(name), (Class<?>)type);
            if (factory == null) {
                factory = this.getFactoryForType(this.forTypeFactories, (Class<?>)type);
            }
            if (factory == null) {
                factory = this.defaultFactory;
            }
            return factory.create(configuration, (Class<?>)type, (String)name);
        };
    }

    private MessageMonitorFactory getFactoryForType(SortedMap<Class<?>, MessageMonitorFactory> map, Class<?> type) {
        if (map == null) {
            return null;
        }
        Class<?> match = null;
        for (Class<?> key : map.keySet()) {
            if (!key.isAssignableFrom(type)) continue;
            if (match != null) {
                if (!match.isAssignableFrom(key)) continue;
                match = key;
                continue;
            }
            match = key;
        }
        if (match == null) {
            return null;
        }
        return (MessageMonitorFactory)map.get(match);
    }

    private void assertNotBuilt() {
        Assert.isFalse((boolean)this.built, () -> "this builder has already been built");
    }
}

