/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.Registration;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.caching.WeakReferenceCache;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.NullLockFactory;
import org.axonframework.common.lock.PessimisticLockFactory;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.Component;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.GenericAggregateFactory;
import org.axonframework.eventsourcing.LegacyEventSourcingRepository;
import org.axonframework.eventsourcing.NoSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.LegacyEventStore;
import org.axonframework.eventsourcing.snapshotting.RevisionSnapshotFilter;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.modelling.command.AggregateAnnotationCommandHandler;
import org.axonframework.modelling.command.AnnotationCommandTargetResolver;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.CreationPolicyAggregateFactory;
import org.axonframework.modelling.command.LegacyGenericJpaRepository;
import org.axonframework.modelling.command.LegacyRepository;
import org.axonframework.modelling.command.RepositorySpanFactory;
import org.axonframework.modelling.command.inspection.AggregateMetaModelFactory;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;
import org.axonframework.serialization.Revision;

public class AggregateConfigurer<A>
implements AggregateConfiguration<A> {
    private final Class<A> aggregate;
    private final Component<AggregateAnnotationCommandHandler<A>> commandHandler;
    private final Component<LegacyRepository<A>> repository;
    private final Component<Cache> cache;
    private final Component<AggregateFactory<A>> aggregateFactory;
    private final Component<CreationPolicyAggregateFactory<A>> creationPolicyAggregateFactory;
    private final Component<LockFactory> lockFactory;
    private final Component<SnapshotTriggerDefinition> snapshotTriggerDefinition;
    private final Component<SnapshotFilter> snapshotFilter;
    private final Component<CommandTargetResolver> commandTargetResolver;
    private final Component<AggregateModel<A>> metaModel;
    private final Component<Predicate<? super DomainEventMessage<?>>> eventStreamFilter;
    private final Component<Boolean> filterEventsByType;
    private final Set<Class<? extends A>> subtypes = new HashSet<Class<? extends A>>();
    private final List<Registration> registrations = new ArrayList<Registration>();
    private LegacyConfiguration parent;

    protected AggregateConfigurer(Class<A> aggregate) {
        this.aggregate = aggregate;
        this.metaModel = new Component<AggregateModel>(() -> this.parent, this.name("aggregateMetaModel"), c -> c.getComponent(AggregateMetaModelFactory.class, () -> new AnnotatedAggregateMetaModelFactory(c.parameterResolverFactory(), c.handlerDefinition(aggregate))).createModel(aggregate, this.subtypes));
        this.commandTargetResolver = new Component<CommandTargetResolver>(() -> this.parent, this.name("commandTargetResolver"), c -> c.getComponent(CommandTargetResolver.class, () -> AnnotationCommandTargetResolver.builder().build()));
        this.lockFactory = new Component<LockFactory>(() -> this.parent, this.name("lockFactory"), c -> PessimisticLockFactory.usingDefaults());
        this.snapshotTriggerDefinition = new Component<SnapshotTriggerDefinition>(() -> this.parent, this.name("snapshotTriggerDefinition"), c -> NoSnapshotTriggerDefinition.INSTANCE);
        this.snapshotFilter = new Component<SnapshotFilter>(() -> this.parent, this.name("snapshotFilter"), c -> {
            String revisionValue = AnnotationUtils.findAnnotationAttribute((AnnotatedElement)aggregate, Revision.class, (String)"revision").orElse(null);
            String declaredAggregateType = (String)this.metaModel.get().declaredType(aggregate).orElseThrow(() -> new AxonConfigurationException("No declared type found for Aggregate [" + String.valueOf(aggregate) + "]"));
            return RevisionSnapshotFilter.builder().type(declaredAggregateType).revision(revisionValue).build();
        });
        this.aggregateFactory = new Component<AggregateFactory>(() -> this.parent, this.name("aggregateFactory"), c -> new GenericAggregateFactory(this.metaModel.get()));
        this.cache = new Component<Cache>(() -> this.parent, this.name("aggregateCache"), c -> null);
        this.eventStreamFilter = new Component<Predicate>(() -> this.parent, this.name("eventStreamFilter"), c -> null);
        this.filterEventsByType = new Component<Boolean>(() -> this.parent, this.name("filterByAggregateType"), c -> false);
        this.repository = new Component<LegacyRepository>(() -> this.parent, this.name("Repository"), c -> {
            Assert.state((boolean)(c.eventBus() instanceof LegacyEventStore), () -> "Default configuration requires the use of event sourcing. Either configure an Event Store to use, or configure a specific repository implementation for " + aggregate.toString());
            LegacyEventSourcingRepository.Builder builder = LegacyEventSourcingRepository.builder((Class)aggregate).aggregateModel(this.metaModel.get()).lockFactory(this.lockFactory.get()).eventStore(c.eventStore()).snapshotTriggerDefinition(this.snapshotTriggerDefinition.get()).aggregateFactory(this.aggregateFactory.get()).repositoryProvider(c::repository).spanFactory(c.getComponent(RepositorySpanFactory.class)).cache(this.cache.get());
            if (this.eventStreamFilter.get() != null) {
                builder = builder.eventStreamFilter(this.eventStreamFilter.get());
            } else if (this.filterEventsByType.get().booleanValue()) {
                builder = builder.filterByAggregateType();
            }
            return builder.build();
        });
        this.creationPolicyAggregateFactory = new Component<CreationPolicyAggregateFactory>(() -> this.parent, this.name("creationPolicyAggregateFactory"), c -> null);
        this.commandHandler = new Component<AggregateAnnotationCommandHandler>(() -> this.parent, this.name("aggregateCommandHandler"), c -> AggregateAnnotationCommandHandler.builder().repository(this.repository.get()).commandTargetResolver(this.commandTargetResolver.get()).aggregateModel(this.metaModel.get()).creationPolicyAggregateFactory(this.creationPolicyAggregateFactory.get()).build());
    }

    public static <A> AggregateConfigurer<A> defaultConfiguration(Class<A> aggregateType) {
        return new AggregateConfigurer<A>(aggregateType);
    }

    public static <A> AggregateConfigurer<A> jpaMappedConfiguration(Class<A> aggregateType) {
        AggregateConfigurer<A> configurer = new AggregateConfigurer<A>(aggregateType).configureLockFactory(config -> NullLockFactory.INSTANCE);
        return configurer.configureRepository(c -> {
            EntityManagerProvider entityManagerProvider = c.getComponent(EntityManagerProvider.class, () -> {
                throw new AxonConfigurationException(String.format("JPA has not been correctly configured for aggregate [%s]. Either provide an EntityManagerProvider, or use DefaultConfigurer.jpaConfiguration(...) to define one for the entire configuration.", aggregateType.getSimpleName()));
            });
            return LegacyGenericJpaRepository.builder((Class)aggregateType).aggregateModel(configurer.metaModel.get()).lockFactory(configurer.lockFactory.get()).entityManagerProvider(entityManagerProvider).eventBus(c.eventBus()).repositoryProvider(c::repository).spanFactory(c.getComponent(RepositorySpanFactory.class)).build();
        });
    }

    public static <A> AggregateConfigurer<A> jpaMappedConfiguration(Class<A> aggregateType, EntityManagerProvider entityManagerProvider) {
        AggregateConfigurer<A> configurer = new AggregateConfigurer<A>(aggregateType).configureLockFactory(config -> NullLockFactory.INSTANCE);
        return configurer.configureRepository(c -> LegacyGenericJpaRepository.builder((Class)aggregateType).aggregateModel(configurer.metaModel.get()).lockFactory(configurer.lockFactory.get()).entityManagerProvider(entityManagerProvider).eventBus(c.eventBus()).repositoryProvider(c::repository).spanFactory(c.getComponent(RepositorySpanFactory.class)).build());
    }

    private String name(String prefix) {
        return prefix + "<" + this.aggregate.getSimpleName() + ">";
    }

    public AggregateConfigurer<A> configureRepository(Function<LegacyConfiguration, LegacyRepository<A>> repositoryBuilder) {
        this.repository.update(repositoryBuilder);
        return this;
    }

    public AggregateConfigurer<A> configureAggregateFactory(Function<LegacyConfiguration, AggregateFactory<A>> aggregateFactoryBuilder) {
        this.aggregateFactory.update(aggregateFactoryBuilder);
        return this;
    }

    public AggregateConfigurer<A> configureCreationPolicyAggregateFactory(Function<LegacyConfiguration, CreationPolicyAggregateFactory<A>> creationPolicyAggregateFactoryBuilder) {
        this.creationPolicyAggregateFactory.update(creationPolicyAggregateFactoryBuilder);
        return this;
    }

    public AggregateConfigurer<A> configureLockFactory(Function<LegacyConfiguration, LockFactory> lockFactory) {
        this.lockFactory.update(lockFactory);
        return this;
    }

    public AggregateConfigurer<A> configureCommandHandler(Function<LegacyConfiguration, AggregateAnnotationCommandHandler<A>> aggregateCommandHandlerBuilder) {
        this.commandHandler.update(aggregateCommandHandlerBuilder);
        return this;
    }

    public AggregateConfigurer<A> configureCommandTargetResolver(Function<LegacyConfiguration, CommandTargetResolver> commandTargetResolverBuilder) {
        this.commandTargetResolver.update(commandTargetResolverBuilder);
        return this;
    }

    public AggregateConfigurer<A> configureSnapshotTrigger(Function<LegacyConfiguration, SnapshotTriggerDefinition> snapshotTriggerDefinition) {
        this.snapshotTriggerDefinition.update(snapshotTriggerDefinition);
        return this;
    }

    public AggregateConfigurer<A> configureSnapshotFilter(Function<LegacyConfiguration, SnapshotFilter> snapshotFilter) {
        this.snapshotFilter.update(snapshotFilter);
        return this;
    }

    public AggregateConfigurer<A> configureEventStreamFilter(Function<LegacyConfiguration, Predicate<? super DomainEventMessage<?>>> filterBuilder) {
        this.eventStreamFilter.update(filterBuilder);
        return this;
    }

    public AggregateConfigurer<A> configureCache(Function<LegacyConfiguration, Cache> cache) {
        this.cache.update(cache);
        return this;
    }

    public AggregateConfigurer<A> configureWeakReferenceCache() {
        return this.configureCache(c -> new WeakReferenceCache());
    }

    public AggregateConfigurer<A> configureFilterEventsByType(Function<LegacyConfiguration, Boolean> filterConfigurationPredicate) {
        this.filterEventsByType.update(filterConfigurationPredicate);
        return this;
    }

    @Override
    public void initialize(LegacyConfiguration config) {
        this.parent = config;
        this.parent.onStart(0, () -> this.parent.commandBus().subscribe((CommandHandlingComponent)this.commandHandler.get()));
        this.parent.onShutdown(0, () -> {
            this.registrations.forEach(Registration::cancel);
            this.registrations.clear();
        });
    }

    @Override
    public LegacyRepository<A> repository() {
        return this.repository.get();
    }

    @Override
    public Class<A> aggregateType() {
        return this.aggregate;
    }

    @Override
    public AggregateFactory<A> aggregateFactory() {
        return this.aggregateFactory.get();
    }

    @Override
    public SnapshotFilter snapshotFilter() {
        return this.snapshotFilter.get();
    }

    @SafeVarargs
    public final AggregateConfigurer<A> withSubtypes(Class<? extends A> ... subtypes) {
        return this.withSubtypes(Arrays.asList(subtypes));
    }

    public AggregateConfigurer<A> withSubtypes(Collection<Class<? extends A>> subtypes) {
        this.subtypes.addAll(subtypes);
        return this;
    }

    public CreationPolicyAggregateFactory<A> creationPolicyAggregateFactory() {
        return this.creationPolicyAggregateFactory.get();
    }
}

