/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.serial;

import com.google.common.util.concurrent.SettableFuture;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.impl.DefaultFuture;
import org.atmosphere.wasync.impl.SocketRuntime;
import org.atmosphere.wasync.serial.SerializedSocket;
import org.atmosphere.wasync.transport.WebSocketTransport;
import org.atmosphere.wasync.util.FutureProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialSocketRuntime
extends SocketRuntime {
    private static final Logger logger = LoggerFactory.getLogger(SerialSocketRuntime.class);
    private final SerializedSocket serializedSocket;

    public SerialSocketRuntime(Transport transport, Options options, DefaultFuture rootFuture, SerializedSocket serializedSocket, List<FunctionWrapper> functions) {
        super(transport, options, rootFuture, functions);
        this.serializedSocket = serializedSocket;
    }

    @Override
    public Future write(Request request, Object data) throws IOException {
        if (!WebSocketTransport.class.isAssignableFrom(this.transport.getClass())) {
            FutureProxy<ListenableFuture<Response>> f;
            Object encodedPayload = this.invokeEncoder(request.encoders(), data);
            if (!(InputStream.class.isAssignableFrom(encodedPayload.getClass()) || Reader.class.isAssignableFrom(encodedPayload.getClass()) || String.class.isAssignableFrom(encodedPayload.getClass()) || byte[].class.isAssignableFrom(encodedPayload.getClass()))) {
                throw new IllegalStateException("No Encoder for " + data);
            }
            if (this.serializedSocket.getSerializedFireStage() != null) {
                SettableFuture future = SettableFuture.create();
                this.serializedSocket.getSerializedFireStage().enqueue(encodedPayload, (SettableFuture<Response>)future);
                f = new FutureProxy<SettableFuture>(this.serializedSocket, future);
            } else {
                f = new FutureProxy<ListenableFuture<Response>>(this.serializedSocket, this.serializedSocket.directWrite(encodedPayload));
            }
            this.transport.future(f);
            return f;
        }
        Object object = this.invokeEncoder(request.encoders(), data);
        this.rootFuture.done();
        this.webSocketWrite(request, object, data);
        return this.rootFuture.finishOrThrowException();
    }
}

