/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.RequestBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.impl.DefaultFuture;
import org.atmosphere.wasync.impl.SocketRuntime;
import org.atmosphere.wasync.transport.LongPollingTransport;
import org.atmosphere.wasync.transport.SSETransport;
import org.atmosphere.wasync.transport.StreamTransport;
import org.atmosphere.wasync.transport.TransportNotSupported;
import org.atmosphere.wasync.transport.WebSocketTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSocket
implements Socket {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSocket.class);
    protected Request request;
    protected SocketRuntime socketRuntime;
    protected final List<FunctionWrapper> functions = new ArrayList<FunctionWrapper>();
    protected Transport transportInUse;
    protected final Options options;

    public DefaultSocket(Options options) {
        this.options = options;
    }

    @Override
    public Future fire(Object data) throws IOException {
        this.checkState();
        if (this.transportInUse.name().equals((Object)Request.TRANSPORT.WEBSOCKET) && this.transportInUse.status().equals((Object)Socket.STATUS.CLOSE) || this.transportInUse.status().equals((Object)Socket.STATUS.ERROR)) {
            this.transportInUse.error(new IOException("Invalid Socket Status " + this.transportInUse.status().name()));
            return this.socketRuntime.rootFuture;
        }
        return this.socketRuntime.write(this.request, data);
    }

    public Socket on(Function<? extends Object> function) {
        return this.on("", function);
    }

    public Socket on(String functionName, Function<? extends Object> function) {
        this.functions.add(new FunctionWrapper(functionName, function));
        return this;
    }

    @Override
    public Socket on(Event event, Function<?> function) {
        return this.on(event.name(), (Function<? extends Object>)function);
    }

    @Override
    public Socket open(Request request) throws IOException {
        return this.open(request, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Socket open(Request request, long timeout, TimeUnit tu) throws IOException {
        this.request = request;
        RequestBuilder r = new RequestBuilder();
        r.setUrl(request.uri()).setMethod(request.method().name()).setHeaders(request.headers()).setQueryParams((Map)DefaultSocket.decodeQueryString(request));
        List<Transport> transports = this.getTransport(r, request);
        return this.connect(r, transports, timeout, tu);
    }

    static FluentStringsMap decodeQueryString(Request request) {
        Map<String, List<String>> c = request.queryString();
        FluentStringsMap f = new FluentStringsMap();
        f.putAll(c);
        return f;
    }

    /*
     * Exception decompiling
     */
    protected Socket connect(RequestBuilder r, List<Transport> transports, long timeout, TimeUnit tu) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String webSocketUrl(String url) {
        return url.startsWith("http://") || url.startsWith("https://") ? "ws" + url.substring(4) : url;
    }

    private String httpUrl(String url) {
        return url.startsWith("ws://") || url.startsWith("wss://") ? "http" + url.substring(2) : url;
    }

    protected void addFunction(final long timeout, final TimeUnit tu) {
        this.functions.add(new FunctionWrapper("", new Function<TransportNotSupported>(){

            @Override
            public void on(TransportNotSupported transportNotSupported) {
                DefaultSocket.this.request.transport().remove(0);
                if (DefaultSocket.this.request.transport().size() > 0) {
                    try {
                        DefaultSocket.this.open(DefaultSocket.this.request, timeout, tu);
                    }
                    catch (IOException e) {
                        logger.error("", (Throwable)e);
                    }
                } else {
                    throw new Error("No suitable transport supported by the server");
                }
            }
        }));
    }

    @Override
    public void close() {
        if (this.transportInUse == null) {
            this.closeRuntime(false);
        } else if (this.socketRuntime != null && !this.transportInUse.status().equals((Object)Socket.STATUS.CLOSE)) {
            this.transportInUse.close();
            this.closeRuntime(true);
        }
    }

    protected void closeRuntime(boolean async) {
        if (!this.options.runtime().isClosed()) {
            if (!this.options.runtimeShared()) {
                if (async) {
                    final ExecutorService e = Executors.newSingleThreadExecutor();
                    e.submit(new Runnable(){

                        @Override
                        public void run() {
                            DefaultSocket.this.options.runtime().close();
                            e.shutdown();
                        }
                    });
                } else {
                    this.options.runtime().close();
                }
            } else {
                logger.warn("Cannot close underlying AsyncHttpClient because it is shared. Make sure you close it manually.");
            }
        }
    }

    @Override
    public Socket.STATUS status() {
        if (this.transportInUse == null) {
            return Socket.STATUS.CLOSE;
        }
        return this.transportInUse.status();
    }

    protected SocketRuntime internalSocket() {
        return this.socketRuntime;
    }

    protected List<Transport> getTransport(RequestBuilder r, Request request) throws IOException {
        ArrayList<Transport> transports = new ArrayList<Transport>();
        if (request.transport().size() == 0) {
            transports.add(new WebSocketTransport(r, this.options, request, this.functions));
            transports.add(new LongPollingTransport(r, this.options, request, this.functions));
        }
        for (Request.TRANSPORT t : request.transport()) {
            if (t.equals((Object)Request.TRANSPORT.WEBSOCKET)) {
                transports.add(new WebSocketTransport(r, this.options, request, this.functions));
                continue;
            }
            if (t.equals((Object)Request.TRANSPORT.SSE)) {
                transports.add(new SSETransport(r, this.options, request, this.functions));
                continue;
            }
            if (t.equals((Object)Request.TRANSPORT.LONG_POLLING)) {
                transports.add(new LongPollingTransport(r, this.options, request, this.functions));
                continue;
            }
            if (!t.equals((Object)Request.TRANSPORT.STREAMING)) continue;
            transports.add(new StreamTransport(r, this.options, request, this.functions));
        }
        return transports;
    }

    protected Request request() {
        return this.request;
    }

    void checkState() {
        if (this.transportInUse == null) {
            throw new IllegalStateException("Invalid Socket Status : Not Connected");
        }
    }

    public SocketRuntime createRuntime(DefaultFuture future, Options options, List<FunctionWrapper> functions) {
        return new SocketRuntime(this.transportInUse, options, future, functions);
    }

    private static final class VoidSocket
    implements Socket {
        private VoidSocket() {
        }

        @Override
        public Future fire(Object data) throws IOException {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        public Socket on(Function<? extends Object> function) {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        public Socket on(String functionMessage, Function<? extends Object> function) {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public Socket on(Event event, Function<?> function) {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public Socket open(Request request) throws IOException {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public void close() {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public Socket.STATUS status() {
            return Socket.STATUS.ERROR;
        }

        @Override
        public Socket open(Request request, long timeout, TimeUnit tu) throws IOException {
            throw new IllegalStateException("An error occured during connection. Please add a Function(Throwable) to debug.");
        }
    }
}

