/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.util;

import com.ning.http.client.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Socket;

public class FutureProxy<T extends java.util.concurrent.Future>
implements Future {
    private final Socket socket;
    private final T proxyiedFuture;
    private IOException ioException;

    public FutureProxy(Socket socket, T proxyiedFuture) {
        this.socket = socket;
        this.proxyiedFuture = proxyiedFuture;
    }

    @Override
    public Future fire(Object data) throws IOException {
        return this.socket.fire(data);
    }

    @Override
    public Future finishOrThrowException() throws IOException {
        this.done();
        if (this.ioException != null) {
            throw this.ioException;
        }
        return this;
    }

    @Override
    public Future ioException(IOException t) {
        this.ioException = t;
        return this;
    }

    @Override
    public void done() {
        if (ListenableFuture.class.isAssignableFrom(this.proxyiedFuture.getClass())) {
            ((ListenableFuture)ListenableFuture.class.cast(this.proxyiedFuture)).done();
        } else if (Future.class.isAssignableFrom(this.proxyiedFuture.getClass())) {
            ((Future)Future.class.cast(this.proxyiedFuture)).done();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (ListenableFuture.class.isAssignableFrom(this.proxyiedFuture.getClass())) {
            return ((ListenableFuture)ListenableFuture.class.cast(this.proxyiedFuture)).cancel(mayInterruptIfRunning);
        }
        if (Future.class.isAssignableFrom(this.proxyiedFuture.getClass())) {
            return ((Future)Future.class.cast(this.proxyiedFuture)).cancel(mayInterruptIfRunning);
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.proxyiedFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.proxyiedFuture.isDone();
    }

    @Override
    public Socket get() throws InterruptedException, ExecutionException {
        this.proxyiedFuture.get();
        return this.socket;
    }

    @Override
    public Socket get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.proxyiedFuture.get(timeout, unit);
        return this.socket;
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

