/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync;

import org.atmosphere.wasync.Client;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.OptionsBuilder;
import org.atmosphere.wasync.RequestBuilder;
import org.atmosphere.wasync.impl.DefaultClient;

public class ClientFactory {
    private static final ClientFactory factory = new ClientFactory();
    private final String clientClassName = System.getProperty("wasync.client");

    public static final ClientFactory getDefault() {
        return factory;
    }

    public Client<? extends Options, ? extends OptionsBuilder, ? extends RequestBuilder> newClient() {
        if (this.clientClassName == null) {
            return new DefaultClient();
        }
        try {
            return (Client)Thread.currentThread().getContextClassLoader().loadClass(this.clientClassName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends Client<? extends Options, ? extends OptionsBuilder, ? extends RequestBuilder>> T newClient(Class<? extends Client> clientClass) {
        try {
            Client client = clientClass.newInstance();
            return (T)client;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

