/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.future;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;

public final class StackTraceInspector {
    private StackTraceInspector() {
    }

    private static boolean exceptionInMethod(Throwable t, String className, String methodName) {
        try {
            for (StackTraceElement element : t.getStackTrace()) {
                if (!element.getClassName().equals(className) || !element.getMethodName().equals(methodName)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean recoverOnConnectCloseException(Throwable t) {
        while (!StackTraceInspector.exceptionInMethod(t, "sun.nio.ch.SocketChannelImpl", "checkConnect")) {
            if (t.getCause() == null) {
                return false;
            }
            t = t.getCause();
        }
        return true;
    }

    public static boolean recoverOnNettyDisconnectException(Throwable t) {
        return t instanceof ClosedChannelException || StackTraceInspector.exceptionInMethod(t, "io.netty.handler.ssl.SslHandler", "disconnect") || t.getCause() != null && StackTraceInspector.recoverOnConnectCloseException(t.getCause());
    }

    public static boolean recoverOnReadOrWriteException(Throwable t) {
        while (!(t instanceof IOException) || !"Connection reset by peer".equalsIgnoreCase(t.getMessage())) {
            try {
                for (StackTraceElement element : t.getStackTrace()) {
                    String className = element.getClassName();
                    String methodName = element.getMethodName();
                    if (!"sun.nio.ch.SocketDispatcher".equals(className) || !"read".equals(methodName) && !"write".equals(methodName)) continue;
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (t.getCause() == null) {
                return false;
            }
            t = t.getCause();
        }
        return true;
    }
}

