/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.util;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;

public class UsAsciiByteBufDecoder {
    private static final FastThreadLocal<UsAsciiByteBufDecoder> POOL = new FastThreadLocal<UsAsciiByteBufDecoder>(){

        protected UsAsciiByteBufDecoder initialValue() {
            return new UsAsciiByteBufDecoder();
        }
    };
    private StringBuilder sb = new StringBuilder();

    public static UsAsciiByteBufDecoder pooled() {
        UsAsciiByteBufDecoder decoder = (UsAsciiByteBufDecoder)POOL.get();
        decoder.reset();
        return decoder;
    }

    public void reset() {
        this.sb.setLength(0);
    }

    public String decode(Iterable<ByteBuf> bufs) {
        for (ByteBuf buf : bufs) {
            buf.forEachByte(b -> {
                this.sb.append((char)b);
                return true;
            });
        }
        return this.sb.toString();
    }
}

