/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.simple;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.ssl.SslContext;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Param;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.SslEngineFactory;
import org.asynchttpclient.extras.simple.BodyConsumer;
import org.asynchttpclient.extras.simple.ResumableBodyConsumer;
import org.asynchttpclient.extras.simple.SimpleAHCTransferListener;
import org.asynchttpclient.extras.simple.ThrowableHandler;
import org.asynchttpclient.filter.IOExceptionFilter;
import org.asynchttpclient.handler.ProgressAsyncHandler;
import org.asynchttpclient.handler.resumable.ResumableAsyncHandler;
import org.asynchttpclient.handler.resumable.ResumableIOExceptionFilter;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.MiscUtils;

public class SimpleAsyncHttpClient
implements Closeable {
    private final AsyncHttpClientConfig config;
    private final RequestBuilder requestBuilder;
    private AsyncHttpClient asyncHttpClient;
    private final ThrowableHandler defaultThrowableHandler;
    private final boolean resumeEnabled;
    private final ErrorDocumentBehaviour errorDocumentBehaviour;
    private final SimpleAHCTransferListener listener;
    private final boolean derived;

    private SimpleAsyncHttpClient(AsyncHttpClientConfig config, RequestBuilder requestBuilder, ThrowableHandler defaultThrowableHandler, ErrorDocumentBehaviour errorDocumentBehaviour, boolean resumeEnabled, AsyncHttpClient ahc, SimpleAHCTransferListener listener) {
        this.config = config;
        this.requestBuilder = requestBuilder;
        this.defaultThrowableHandler = defaultThrowableHandler;
        this.resumeEnabled = resumeEnabled;
        this.errorDocumentBehaviour = errorDocumentBehaviour;
        this.asyncHttpClient = ahc;
        this.listener = listener;
        this.derived = ahc != null;
    }

    public Future<Response> post(Part ... parts) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        for (Part part : parts) {
            r.addBodyPart(part);
        }
        return this.execute(r, null, null);
    }

    public Future<Response> post(BodyConsumer consumer, Part ... parts) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        for (Part part : parts) {
            r.addBodyPart(part);
        }
        return this.execute(r, consumer, null);
    }

    public Future<Response> post(BodyGenerator bodyGenerator) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        r.setBody(bodyGenerator);
        return this.execute(r, null, null);
    }

    public Future<Response> post(BodyGenerator bodyGenerator, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        r.setBody(bodyGenerator);
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> post(BodyGenerator bodyGenerator, BodyConsumer bodyConsumer) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        r.setBody(bodyGenerator);
        return this.execute(r, bodyConsumer, null);
    }

    public Future<Response> post(BodyGenerator bodyGenerator, BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        r.setBody(bodyGenerator);
        return this.execute(r, bodyConsumer, throwableHandler);
    }

    public Future<Response> put(Part ... parts) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        for (Part part : parts) {
            r.addBodyPart(part);
        }
        return this.execute(r, null, null);
    }

    public Future<Response> put(BodyConsumer consumer, Part ... parts) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("POST");
        for (Part part : parts) {
            r.addBodyPart(part);
        }
        return this.execute(r, consumer, null);
    }

    public Future<Response> put(BodyGenerator bodyGenerator, BodyConsumer bodyConsumer) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("PUT");
        r.setBody(bodyGenerator);
        return this.execute(r, bodyConsumer, null);
    }

    public Future<Response> put(BodyGenerator bodyGenerator, BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("PUT");
        r.setBody(bodyGenerator);
        return this.execute(r, bodyConsumer, throwableHandler);
    }

    public Future<Response> put(BodyGenerator bodyGenerator) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("PUT");
        r.setBody(bodyGenerator);
        return this.execute(r, null, null);
    }

    public Future<Response> put(BodyGenerator bodyGenerator, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("PUT");
        r.setBody(bodyGenerator);
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> get() throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        return this.execute(r, null, null);
    }

    public Future<Response> get(ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> get(BodyConsumer bodyConsumer) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        return this.execute(r, bodyConsumer, null);
    }

    public Future<Response> get(BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        return this.execute(r, bodyConsumer, throwableHandler);
    }

    public Future<Response> delete() throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("DELETE");
        return this.execute(r, null, null);
    }

    public Future<Response> delete(ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("DELETE");
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> delete(BodyConsumer bodyConsumer) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("DELETE");
        return this.execute(r, bodyConsumer, null);
    }

    public Future<Response> delete(BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("DELETE");
        return this.execute(r, bodyConsumer, throwableHandler);
    }

    public Future<Response> head() throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("HEAD");
        return this.execute(r, null, null);
    }

    public Future<Response> head(ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("HEAD");
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> options() throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("OPTIONS");
        return this.execute(r, null, null);
    }

    public Future<Response> options(ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("OPTIONS");
        return this.execute(r, null, throwableHandler);
    }

    public Future<Response> options(BodyConsumer bodyConsumer) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("OPTIONS");
        return this.execute(r, bodyConsumer, null);
    }

    public Future<Response> options(BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        RequestBuilder r = this.rebuildRequest(this.requestBuilder.build());
        r.setMethod("OPTIONS");
        return this.execute(r, bodyConsumer, throwableHandler);
    }

    private RequestBuilder rebuildRequest(Request rb) {
        return new RequestBuilder(rb);
    }

    private Future<Response> execute(RequestBuilder rb, BodyConsumer bodyConsumer, ThrowableHandler throwableHandler) throws IOException {
        if (throwableHandler == null) {
            throwableHandler = this.defaultThrowableHandler;
        }
        Request request = rb.build();
        Object handler = new BodyConsumerAsyncHandler(bodyConsumer, throwableHandler, this.errorDocumentBehaviour, request.getUri(), this.listener);
        if (this.resumeEnabled && request.getMethod().equals("GET") && bodyConsumer != null && bodyConsumer instanceof ResumableBodyConsumer) {
            ResumableBodyConsumer fileBodyConsumer = (ResumableBodyConsumer)bodyConsumer;
            long length = fileBodyConsumer.getTransferredBytes();
            fileBodyConsumer.resume();
            handler = new ResumableBodyConsumerAsyncHandler(length, (ProgressAsyncHandler<Response>)handler);
        }
        return this.getAsyncHttpClient().executeRequest(request, (AsyncHandler)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncHttpClient getAsyncHttpClient() {
        AsyncHttpClientConfig asyncHttpClientConfig = this.config;
        synchronized (asyncHttpClientConfig) {
            if (this.asyncHttpClient == null) {
                this.asyncHttpClient = Dsl.asyncHttpClient((AsyncHttpClientConfig)this.config);
            }
        }
        return this.asyncHttpClient;
    }

    @Override
    public void close() throws IOException {
        if (!this.derived && this.asyncHttpClient != null) {
            this.asyncHttpClient.close();
        }
    }

    public DerivedBuilder derive() {
        return new Builder(this);
    }

    private static final class BodyConsumerAsyncHandler
    extends AsyncCompletionHandlerBase {
        private final BodyConsumer bodyConsumer;
        private final ThrowableHandler exceptionHandler;
        private final ErrorDocumentBehaviour errorDocumentBehaviour;
        private final Uri uri;
        private final SimpleAHCTransferListener listener;
        private boolean accumulateBody = false;
        private boolean omitBody = false;
        private int amount = 0;
        private long total = -1L;

        public BodyConsumerAsyncHandler(BodyConsumer bodyConsumer, ThrowableHandler exceptionHandler, ErrorDocumentBehaviour errorDocumentBehaviour, Uri uri, SimpleAHCTransferListener listener) {
            this.bodyConsumer = bodyConsumer;
            this.exceptionHandler = exceptionHandler;
            this.errorDocumentBehaviour = errorDocumentBehaviour;
            this.uri = uri;
            this.listener = listener;
        }

        public void onThrowable(Throwable t) {
            try {
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.onThrowable(t);
                } else {
                    super.onThrowable(t);
                }
            }
            finally {
                this.closeConsumer();
            }
        }

        public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
            this.fireReceived(content);
            if (this.omitBody) {
                return AsyncHandler.State.CONTINUE;
            }
            if (this.accumulateBody || this.bodyConsumer == null) {
                return super.onBodyPartReceived(content);
            }
            this.bodyConsumer.consume(content.getBodyByteBuffer());
            return AsyncHandler.State.CONTINUE;
        }

        public Response onCompleted(Response response) throws Exception {
            this.fireCompleted(response);
            this.closeConsumer();
            return super.onCompleted(response);
        }

        private void closeConsumer() {
            if (this.bodyConsumer != null) {
                MiscUtils.closeSilently((Closeable)this.bodyConsumer);
            }
        }

        public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
            this.fireStatus(status);
            if (this.isErrorStatus(status)) {
                switch (this.errorDocumentBehaviour) {
                    case ACCUMULATE: {
                        this.accumulateBody = true;
                        break;
                    }
                    case OMIT: {
                        this.omitBody = true;
                        break;
                    }
                }
            }
            return super.onStatusReceived(status);
        }

        private boolean isErrorStatus(HttpResponseStatus status) {
            return status.getStatusCode() >= 400;
        }

        public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
            this.calculateTotal(headers);
            this.fireHeaders(headers);
            return super.onHeadersReceived(headers);
        }

        private void calculateTotal(HttpHeaders headers) {
            String length = headers.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            try {
                this.total = Integer.valueOf(length).intValue();
            }
            catch (Exception e) {
                this.total = -1L;
            }
        }

        public AsyncHandler.State onContentWriteProgress(long amount, long current, long total) {
            this.fireSent(this.uri, amount, current, total);
            return super.onContentWriteProgress(amount, current, total);
        }

        private void fireStatus(HttpResponseStatus status) {
            if (this.listener != null) {
                this.listener.onStatus(this.uri, status.getStatusCode(), status.getStatusText());
            }
        }

        private void fireReceived(HttpResponseBodyPart content) {
            int remaining = content.getBodyByteBuffer().remaining();
            this.amount += remaining;
            if (this.listener != null) {
                this.listener.onBytesReceived(this.uri, this.amount, remaining, this.total);
            }
        }

        private void fireHeaders(HttpHeaders headers) {
            if (this.listener != null) {
                this.listener.onHeaders(this.uri, headers);
            }
        }

        private void fireSent(Uri uri, long amount, long current, long total) {
            if (this.listener != null) {
                this.listener.onBytesSent(uri, amount, current, total);
            }
        }

        private void fireCompleted(Response response) {
            if (this.listener != null) {
                this.listener.onCompleted(this.uri, response.getStatusCode(), response.getStatusText());
            }
        }
    }

    private static final class ResumableBodyConsumerAsyncHandler
    extends ResumableAsyncHandler
    implements ProgressAsyncHandler<Response> {
        private final ProgressAsyncHandler<Response> delegate;

        public ResumableBodyConsumerAsyncHandler(long byteTransferred, ProgressAsyncHandler<Response> delegate) {
            super(byteTransferred, delegate);
            this.delegate = delegate;
        }

        public AsyncHandler.State onHeadersWritten() {
            return this.delegate.onHeadersWritten();
        }

        public AsyncHandler.State onContentWritten() {
            return this.delegate.onContentWritten();
        }

        public AsyncHandler.State onContentWriteProgress(long amount, long current, long total) {
            return this.delegate.onContentWriteProgress(amount, current, total);
        }
    }

    public static final class Builder
    implements DerivedBuilder {
        private final RequestBuilder requestBuilder;
        private final DefaultAsyncHttpClientConfig.Builder configBuilder = Dsl.config();
        private Realm.Builder realmBuilder = null;
        private Realm.AuthScheme proxyAuthScheme;
        private String proxyHost = null;
        private String proxyPrincipal = null;
        private String proxyPassword = null;
        private int proxyPort = 80;
        private ThrowableHandler defaultThrowableHandler = null;
        private boolean enableResumableDownload = false;
        private ErrorDocumentBehaviour errorDocumentBehaviour = ErrorDocumentBehaviour.WRITE;
        private AsyncHttpClient ahc = null;
        private SimpleAHCTransferListener listener = null;

        public Builder() {
            this.requestBuilder = new RequestBuilder("GET", false);
        }

        private Builder(SimpleAsyncHttpClient client) {
            this.requestBuilder = new RequestBuilder(client.requestBuilder.build());
            this.defaultThrowableHandler = client.defaultThrowableHandler;
            this.errorDocumentBehaviour = client.errorDocumentBehaviour;
            this.enableResumableDownload = client.resumeEnabled;
            this.ahc = client.getAsyncHttpClient();
            this.listener = client.listener;
        }

        @Override
        public Builder addBodyPart(Part part) {
            this.requestBuilder.addBodyPart(part);
            return this;
        }

        @Override
        public Builder addCookie(Cookie cookie) {
            this.requestBuilder.addCookie(cookie);
            return this;
        }

        @Override
        public Builder addHeader(CharSequence name, Object value) {
            this.requestBuilder.addHeader(name, value);
            return this;
        }

        @Override
        public Builder addFormParam(String key, String value) {
            this.requestBuilder.addFormParam(key, value);
            return this;
        }

        @Override
        public Builder addQueryParam(String name, String value) {
            this.requestBuilder.addQueryParam(name, value);
            return this;
        }

        @Override
        public Builder setHeader(CharSequence name, Object value) {
            this.requestBuilder.setHeader(name, value);
            return this;
        }

        @Override
        public Builder setHeaders(HttpHeaders headers) {
            this.requestBuilder.setHeaders(headers);
            return this;
        }

        @Override
        public Builder setHeaders(Map<CharSequence, Collection<?>> headers) {
            this.requestBuilder.setHeaders(headers);
            return this;
        }

        @Override
        public Builder setFormParams(Map<String, List<String>> parameters) {
            this.requestBuilder.setFormParams(parameters);
            return this;
        }

        @Override
        public Builder setFormParams(List<Param> params) {
            this.requestBuilder.setFormParams(params);
            return this;
        }

        @Override
        public Builder setUrl(String url) {
            this.requestBuilder.setUrl(url);
            return this;
        }

        @Override
        public Builder setVirtualHost(String virtualHost) {
            this.requestBuilder.setVirtualHost(virtualHost);
            return this;
        }

        @Override
        public Builder setFollowRedirect(boolean followRedirect) {
            this.requestBuilder.setFollowRedirect(followRedirect);
            return this;
        }

        public Builder setMaxConnections(int defaultMaxConnections) {
            this.configBuilder.setMaxConnections(defaultMaxConnections);
            return this;
        }

        public Builder setMaxConnectionsPerHost(int defaultMaxConnectionsPerHost) {
            this.configBuilder.setMaxConnectionsPerHost(defaultMaxConnectionsPerHost);
            return this;
        }

        public Builder setConnectTimeout(int connectTimeuot) {
            this.configBuilder.setConnectTimeout(connectTimeuot);
            return this;
        }

        public Builder setPooledConnectionIdleTimeout(int pooledConnectionIdleTimeout) {
            this.configBuilder.setPooledConnectionIdleTimeout(pooledConnectionIdleTimeout);
            return this;
        }

        public Builder setRequestTimeout(int defaultRequestTimeout) {
            this.configBuilder.setRequestTimeout(defaultRequestTimeout);
            return this;
        }

        public Builder setMaxRedirects(int maxRedirects) {
            this.configBuilder.setMaxRedirects(maxRedirects);
            return this;
        }

        public Builder setCompressionEnforced(boolean compressionEnforced) {
            this.configBuilder.setCompressionEnforced(compressionEnforced);
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.configBuilder.setUserAgent(userAgent);
            return this;
        }

        public Builder setKeepAlive(boolean allowPoolingConnections) {
            this.configBuilder.setKeepAlive(allowPoolingConnections);
            return this;
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.configBuilder.setThreadFactory(threadFactory);
            return this;
        }

        public Builder setSslContext(SslContext sslContext) {
            this.configBuilder.setSslContext(sslContext);
            return this;
        }

        public Builder setSslEngineFactory(SslEngineFactory sslEngineFactory) {
            this.configBuilder.setSslEngineFactory(sslEngineFactory);
            return this;
        }

        public Builder setRealm(Realm realm) {
            this.configBuilder.setRealm(realm);
            return this;
        }

        public Builder setProxyAuthScheme(Realm.AuthScheme proxyAuthScheme) {
            this.proxyAuthScheme = proxyAuthScheme;
            return this;
        }

        public Builder setProxyHost(String host) {
            this.proxyHost = host;
            return this;
        }

        public Builder setProxyPrincipal(String principal) {
            this.proxyPrincipal = principal;
            return this;
        }

        public Builder setProxyPassword(String password) {
            this.proxyPassword = password;
            return this;
        }

        public Builder setProxyPort(int port) {
            this.proxyPort = port;
            return this;
        }

        public Builder setDefaultThrowableHandler(ThrowableHandler throwableHandler) {
            this.defaultThrowableHandler = throwableHandler;
            return this;
        }

        public Builder setErrorDocumentBehaviour(ErrorDocumentBehaviour behaviour) {
            this.errorDocumentBehaviour = behaviour;
            return this;
        }

        @Override
        public Builder setResumableDownload(boolean enableResumableDownload) {
            this.enableResumableDownload = enableResumableDownload;
            return this;
        }

        public Builder setListener(SimpleAHCTransferListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder setMaxRequestRetry(int maxRequestRetry) {
            this.configBuilder.setMaxRequestRetry(maxRequestRetry);
            return this;
        }

        public Builder setAcceptAnyCertificate(boolean acceptAnyCertificate) {
            this.configBuilder.setUseInsecureTrustManager(acceptAnyCertificate);
            return this;
        }

        @Override
        public SimpleAsyncHttpClient build() {
            if (this.realmBuilder != null) {
                this.configBuilder.setRealm(this.realmBuilder.build());
            }
            if (this.proxyHost != null) {
                Realm realm = null;
                if (this.proxyPrincipal != null) {
                    Realm.AuthScheme proxyAuthScheme = (Realm.AuthScheme)MiscUtils.withDefault((Object)this.proxyAuthScheme, (Object)Realm.AuthScheme.BASIC);
                    realm = Dsl.realm((Realm.AuthScheme)proxyAuthScheme, (String)this.proxyPrincipal, (String)this.proxyPassword).build();
                }
                this.configBuilder.setProxyServer(Dsl.proxyServer((String)this.proxyHost, (int)this.proxyPort).setRealm(realm).build());
            }
            this.configBuilder.addIOExceptionFilter((IOExceptionFilter)new ResumableIOExceptionFilter());
            SimpleAsyncHttpClient sc = new SimpleAsyncHttpClient((AsyncHttpClientConfig)this.configBuilder.build(), this.requestBuilder, this.defaultThrowableHandler, this.errorDocumentBehaviour, this.enableResumableDownload, this.ahc, this.listener);
            return sc;
        }
    }

    public static interface DerivedBuilder {
        public DerivedBuilder setFollowRedirect(boolean var1);

        public DerivedBuilder setVirtualHost(String var1);

        public DerivedBuilder setUrl(String var1);

        public DerivedBuilder setFormParams(List<Param> var1);

        public DerivedBuilder setFormParams(Map<String, List<String>> var1);

        public DerivedBuilder setHeaders(Map<CharSequence, Collection<?>> var1);

        public DerivedBuilder setHeaders(HttpHeaders var1);

        public DerivedBuilder setHeader(CharSequence var1, Object var2);

        public DerivedBuilder addQueryParam(String var1, String var2);

        public DerivedBuilder addFormParam(String var1, String var2);

        public DerivedBuilder addHeader(CharSequence var1, Object var2);

        public DerivedBuilder addCookie(Cookie var1);

        public DerivedBuilder addBodyPart(Part var1);

        public DerivedBuilder setResumableDownload(boolean var1);

        public SimpleAsyncHttpClient build();
    }

    public static enum ErrorDocumentBehaviour {
        WRITE,
        ACCUMULATE,
        OMIT;

    }
}

