/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.rxjava;

import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Func0;
import rx.subjects.ReplaySubject;

public class AsyncHttpObservable {
    public static Observable<Response> toObservable(Func0<BoundRequestBuilder> supplier) {
        final BoundRequestBuilder builder = (BoundRequestBuilder)supplier.call();
        return Observable.unsafeCreate((Observable.OnSubscribe)new Observable.OnSubscribe<Response>(){

            public void call(final Subscriber<? super Response> subscriber) {
                try {
                    AsyncCompletionHandler<Void> handler = new AsyncCompletionHandler<Void>(){

                        public Void onCompleted(Response response) throws Exception {
                            subscriber.onNext((Object)response);
                            subscriber.onCompleted();
                            return null;
                        }

                        public void onThrowable(Throwable t) {
                            subscriber.onError(t);
                        }
                    };
                    builder.execute((AsyncHandler)handler);
                }
                catch (Throwable t) {
                    subscriber.onError(t);
                }
            }
        });
    }

    public static Observable<Response> observe(Func0<BoundRequestBuilder> supplier) {
        ReplaySubject subject = ReplaySubject.create();
        AsyncHttpObservable.toObservable(supplier).subscribe((Observer)subject);
        return subject;
    }
}

