/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.rxjava.single;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.extras.rxjava.UnsubscribedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.SingleSubscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;

abstract class AbstractSingleSubscriberBridge<T>
implements AsyncHandler<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSingleSubscriberBridge.class);
    protected final SingleSubscriber<T> subscriber;
    private final AtomicBoolean delegateTerminated = new AtomicBoolean();

    protected AbstractSingleSubscriberBridge(SingleSubscriber<T> subscriber) {
        this.subscriber = Objects.requireNonNull(subscriber);
    }

    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        return this.subscriber.isUnsubscribed() ? this.abort() : this.delegate().onBodyPartReceived(content);
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        return this.subscriber.isUnsubscribed() ? this.abort() : this.delegate().onStatusReceived(status);
    }

    public AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        return this.subscriber.isUnsubscribed() ? this.abort() : this.delegate().onHeadersReceived(headers);
    }

    public Void onCompleted() {
        Object result;
        if (this.delegateTerminated.getAndSet(true)) {
            return null;
        }
        try {
            result = this.delegate().onCompleted();
        }
        catch (Throwable t) {
            this.emitOnError(t);
            return null;
        }
        if (!this.subscriber.isUnsubscribed()) {
            this.subscriber.onSuccess(result);
        }
        return null;
    }

    public void onThrowable(Throwable t) {
        if (this.delegateTerminated.getAndSet(true)) {
            return;
        }
        Throwable error = t;
        try {
            this.delegate().onThrowable(t);
        }
        catch (Throwable x) {
            error = new CompositeException(Arrays.asList(t, x));
        }
        this.emitOnError(error);
    }

    protected AsyncHandler.State abort() {
        if (!this.delegateTerminated.getAndSet(true)) {
            this.delegate().onThrowable((Throwable)new UnsubscribedException());
        }
        return AsyncHandler.State.ABORT;
    }

    protected abstract AsyncHandler<? extends T> delegate();

    private void emitOnError(Throwable error) {
        Exceptions.throwIfFatal((Throwable)error);
        if (!this.subscriber.isUnsubscribed()) {
            this.subscriber.onError(error);
        } else {
            LOGGER.debug("Not propagating onError after unsubscription: {}", (Object)error.getMessage(), (Object)error);
        }
    }
}

